/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.controls;

import de.javasoft.combobox.controls.AbstractComboBoxEditor;
import de.javasoft.combobox.controls.ColorPopupPanel;
import java.awt.Color;
import java.text.ParseException;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JFormattedTextField;

public class ColorComboBoxEditor
extends AbstractComboBoxEditor {
    private boolean includeAlphaValue;
    private boolean acceptNullValue;

    public ColorComboBoxEditor(ComboBoxEditor defaultEditor, CellEditor cellEditor, boolean includeAlphaValue, boolean acceptNullValue) {
        super(defaultEditor, cellEditor);
        this.includeAlphaValue = includeAlphaValue;
        this.acceptNullValue = acceptNullValue;
    }

    @Override
    protected JFormattedTextField.AbstractFormatter createFormatter() {
        JFormattedTextField.AbstractFormatter formatter = new JFormattedTextField.AbstractFormatter(){

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (ColorComboBoxEditor.this.acceptNullValue && (text == null || text.length() == 0)) {
                    return null;
                }
                return ColorPopupPanel.parseColor(text, ColorComboBoxEditor.this.includeAlphaValue);
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    return null;
                }
                return ColorPopupPanel.colorAsText((Color)value, false, ColorComboBoxEditor.this.includeAlphaValue);
            }
        };
        return formatter;
    }

    public boolean isAlphaValueIncluded() {
        return this.includeAlphaValue;
    }
}

