/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.controls;

import de.javasoft.combobox.controls.AbstractComboBoxEditor;
import de.javasoft.combobox.controls.FontPopupPanel;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JFormattedTextField;

public class FontComboBoxEditor
extends AbstractComboBoxEditor {
    private boolean acceptNullValue;

    public FontComboBoxEditor(ComboBoxEditor defaultEditor, CellEditor cellEditor, boolean acceptNullValue) {
        super(defaultEditor, cellEditor);
        this.acceptNullValue = acceptNullValue;
    }

    @Override
    protected JFormattedTextField.AbstractFormatter createFormatter() {
        JFormattedTextField.AbstractFormatter formatter = new JFormattedTextField.AbstractFormatter(){

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (FontComboBoxEditor.this.acceptNullValue && (text == null || text.length() == 0)) {
                    return null;
                }
                return FontPopupPanel.parseFont(text);
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    return null;
                }
                return FontPopupPanel.fontAsText((Font)value);
            }
        };
        return formatter;
    }
}

