/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.switchbutton.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.switchbutton.JYSwitchButton;
import de.javasoft.switchbutton.ui.JYSwitchButtonUI;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicJYSwitchButtonUI
extends JYSwitchButtonUI {
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicJYSwitchButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installComponents(c);
        this.installDefaults(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallComponents(c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "rolloverEnabled", Boolean.TRUE);
        b.setLayout(new BorderLayout());
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.propertyChangeListener = this.createPropertyChangeListener();
        b.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installDefaults(JComponent c) {
        JYSwitchButton b = (JYSwitchButton)c;
        JLabel onLabel = this.getSwitch(b, true);
        JLabel offLabel = this.getSwitch(b, false);
        b.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"JYSwitchButton.opaque", (Component)b));
        if (b.getBorder() == null || b.getBorder() instanceof UIResource) {
            b.setBorder(WidgetUtils.createOrientationAwareEmptyBorder(SyntheticaLookAndFeel.getInsets((String)"JYSwitchButton.insets", (Component)c, (Insets)new Insets(4, 4, 4, 4), (boolean)true), true));
        }
        if (b.onForegroundIsUIResource()) {
            Color color = SyntheticaLookAndFeel.getColor((String)"JYSwitchButton.switch.onForeground", (Component)b, (Color)new Color(0xFFFFFF));
            b.setOnForeground(color, true);
        } else {
            onLabel.setForeground(this.getSwitchForeground(b, true));
        }
        if (b.onTextIsUIResource()) {
            String text = SyntheticaLookAndFeel.getString((String)"JYSwitchButton.switch.onText", (Component)b);
            b.setOnText(text, true);
        } else {
            onLabel.setText(b.getOnText());
        }
        if (b.onFontSizeIsUIResource()) {
            int size = SyntheticaLookAndFeel.getInt((String)"JYSwitchButton.switch.onFontSize", (Component)b, (int)SyntheticaLookAndFeel.getFontSize());
            if (size == 0) {
                size = b.getFont().getSize() - 1;
            }
            b.setOnFontSize(size, true);
        } else {
            onLabel.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)b.getOnFontStyle(), b.getOnFontSize()));
        }
        if (b.onFontStyleIsUIResource()) {
            int style = SyntheticaLookAndFeel.getInt((String)"JYSwitchButton.switch.onFontStyle", (Component)b, (int)0);
            b.setOnFontStyle(style, true);
        } else {
            onLabel.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)b.getOnFontStyle(), b.getOnFontSize()));
        }
        if (b.offForegroundIsUIResource()) {
            Color color = SyntheticaLookAndFeel.getColor((String)"JYSwitchButton.switch.offForeground", (Component)b, (Color)new Color(0));
            b.setOffForeground(color, true);
        } else {
            offLabel.setForeground(this.getSwitchForeground(b, false));
        }
        if (b.offTextIsUIResource()) {
            String text = SyntheticaLookAndFeel.getString((String)"JYSwitchButton.switch.offText", (Component)b);
            b.setOffText(text, true);
        } else {
            offLabel.setText(b.getOffText());
        }
        if (b.offFontSizeIsUIResource()) {
            int size = SyntheticaLookAndFeel.getInt((String)"JYSwitchButton.switch.offFontSize", (Component)b, (int)SyntheticaLookAndFeel.getFontSize());
            if (size == 0) {
                size = b.getFont().getSize() - 1;
            }
            b.setOffFontSize(size, true);
        } else {
            offLabel.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)b.getOffFontStyle(), b.getOffFontSize()));
        }
        if (b.offFontStyleIsUIResource()) {
            int style = SyntheticaLookAndFeel.getInt((String)"JYSwitchButton.switch.offFontStyle", (Component)b, (int)0);
            b.setOffFontStyle(style, true);
        } else {
            offLabel.setFont(new Font(SyntheticaLookAndFeel.getFontName(), (int)b.getOffFontStyle(), b.getOffFontSize()));
        }
        if (b.textGapIsUIResource()) {
            int gap = SyntheticaLookAndFeel.getInt((String)"JYSwitchButton.textGap", (Component)b, (int)6, (boolean)true);
            b.setTextGap(gap);
        }
        Insets onInsets = SyntheticaLookAndFeel.getInsets((String)"JYSwitchButton.switch.onInsets", (Component)b, (Insets)new Insets(1, 6, 1, 6), (boolean)true);
        this.getSwitch(b, true).setBorder(WidgetUtils.createOrientationAwareEmptyBorder(onInsets, false));
        Insets offInsets = SyntheticaLookAndFeel.getInsets((String)"JYSwitchButton.switch.offInsets", (Component)b, (Insets)new Insets(1, 6, 1, 6), (boolean)true);
        this.getSwitch(b, false).setBorder(WidgetUtils.createOrientationAwareEmptyBorder(offInsets, false));
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(this.propertyChangeListener);
    }

    private void installComponents(JComponent c) {
        final AbstractButton b = (AbstractButton)c;
        JPanel p = new JPanel(){
            private static final long serialVersionUID = 5641577238552939577L;

            @Override
            protected void paintComponent(Graphics g) {
                BasicJYSwitchButtonUI.this.paintSwitchBackground(b, b.isSelected(), g, 0, 0, this.getWidth(), this.getHeight());
            }

            @Override
            public boolean hasFocus() {
                Container parent = this.getParent();
                return parent == null ? false : parent.hasFocus();
            }
        };
        p.setName("JYSwitchButton.SwitchPanel");
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 2));
        p.add(new OnOffSwitch(true));
        p.add(new OnOffSwitch(false));
        c.add((Component)p, "Before");
    }

    private void uninstallComponents(JComponent c) {
        c.removeAll();
    }

    private Color getSwitchForeground(JYSwitchButton b, boolean onColor) {
        Color color = onColor ? b.getOnForeground() : b.getOffForeground();
        boolean disabledForegroundSupport = SyntheticaLookAndFeel.getBoolean((String)"JYSwitchButton.switch.disabledForegroundSupport.enabled", (Component)b, (boolean)true);
        if (b.isEnabled() || !disabledForegroundSupport) {
            color = new Color(color.getRGB(), color.getAlpha() < 255);
        } else {
            int alpha = SyntheticaLookAndFeel.getInt((String)"JYSwitchButton.switch.disabledForegroundAlpha", (Component)b, (int)128);
            color = new Color(alpha << 24 | 0xFFFFFF & color.getRGB(), true);
        }
        return color;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JYSwitchButton b = (JYSwitchButton)evt.getSource();
                String name = evt.getPropertyName();
                if ("onForeground".equals(name)) {
                    BasicJYSwitchButtonUI.this.getSwitch(b, true).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(b, true));
                } else if ("onText".equals(name)) {
                    BasicJYSwitchButtonUI.this.getSwitch(b, true).setText((String)evt.getNewValue());
                } else if ("offForeground".equals(name)) {
                    BasicJYSwitchButtonUI.this.getSwitch(b, false).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(b, false));
                } else if ("offText".equals(name)) {
                    BasicJYSwitchButtonUI.this.getSwitch(b, false).setText((String)evt.getNewValue());
                } else if ("enabled".equals(name)) {
                    BasicJYSwitchButtonUI.this.getSwitch(b, true).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(b, true));
                    BasicJYSwitchButtonUI.this.getSwitch(b, false).setForeground(BasicJYSwitchButtonUI.this.getSwitchForeground(b, false));
                } else if ("textGap".equals(name)) {
                    b.setIconTextGap((Integer)evt.getNewValue());
                } else if ("onFontSize".equals(name) || "onFontStyle".equals(name)) {
                    int size = b.getOnFontSize();
                    Integer style = b.getOnFontStyle();
                    Font f = new Font(SyntheticaLookAndFeel.getFontName(), style == null ? 0 : style, size);
                    BasicJYSwitchButtonUI.this.getSwitch(b, true).setFont(f);
                } else if ("offFontSize".equals(name) || "offFontStyle".equals(name)) {
                    int size = b.getOffFontSize();
                    Integer style = b.getOffFontStyle();
                    Font f = new Font(SyntheticaLookAndFeel.getFontName(), style == null ? 0 : style, size);
                    BasicJYSwitchButtonUI.this.getSwitch(b, false).setFont(f);
                }
            }
        };
    }

    private JLabel getSwitch(JYSwitchButton b, boolean onState) {
        Component c = ((BorderLayout)b.getLayout()).getLayoutComponent("Before");
        OnOffSwitch onOffSwitch = (OnOffSwitch)((Container)c).getComponent(onState ? 0 : 1);
        return (JLabel)onOffSwitch.getComponent(0);
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        this.paintBackground(c, g, 0, 0, c.getWidth(), c.getHeight());
        super.paint(g, c);
    }

    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h) {
    }

    protected void paintSwitchBackground(JComponent c, boolean selected, Graphics g, int x, int y, int w, int h) {
        g.setColor(selected ? new Color(35020) : new Color(0xCCCCCC));
        g.fillRect(x, y, w, h);
    }

    protected void paintSwitch(JComponent c, boolean selected, Graphics g, int x, int y, int w, int h) {
        g.setColor(Color.GRAY);
        g.fillRect(x, y, w, h);
    }

    private class OnOffSwitch
    extends JPanel {
        private static final long serialVersionUID = -9102350711337593954L;
        private boolean isOnSwitch;

        public OnOffSwitch(boolean isOnSwitch) {
            this.isOnSwitch = isOnSwitch;
            this.setLayout(new BorderLayout());
            this.add(this.createLabel(isOnSwitch));
            this.setOpaque(false);
        }

        private JYSwitchButton getSwitchButton() {
            return (JYSwitchButton)this.getParent().getParent();
        }

        private JLabel createLabel(final boolean isOnSwitch) {
            JLabel l = new JLabel(" "){
                private static final long serialVersionUID = 4027249822886417331L;

                @Override
                protected void paintComponent(Graphics g) {
                    boolean dynamicForeground = SyntheticaLookAndFeel.getBoolean((String)"JYSwitchButton.switch.dynamicForeground.enabled", (Component)OnOffSwitch.this.getSwitchButton(), (boolean)false);
                    Color oldForeground = this.getForeground();
                    if (dynamicForeground) {
                        this.setForeground(BasicJYSwitchButtonUI.this.getSwitch(OnOffSwitch.this.getSwitchButton(), isOnSwitch ? OnOffSwitch.this.getSwitchButton().isSelected() : !OnOffSwitch.this.getSwitchButton().isSelected()).getForeground());
                    }
                    super.paintComponent(g);
                    boolean isOnSwitch2 = OnOffSwitch.this.isOnSwitch;
                    boolean selected = OnOffSwitch.this.getSwitchButton().isSelected();
                    if (!(isOnSwitch2 && selected || !isOnSwitch2 && !selected)) {
                        BasicJYSwitchButtonUI.this.paintSwitch(OnOffSwitch.this.getSwitchButton(), selected, g, 0, 0, this.getWidth(), this.getHeight());
                    }
                    if (dynamicForeground) {
                        this.setForeground(oldForeground);
                    }
                }
            };
            l.setHorizontalAlignment(0);
            l.setFocusable(false);
            l.setName(isOnSwitch ? "JYSwitchButton.OnSwitch" : "JYSwitchButton.OffSwitch");
            return l;
        }

        @Override
        public Dimension getPreferredSize() {
            JYSwitchButton b = this.getSwitchButton();
            int width = Math.max(((BasicJYSwitchButtonUI)BasicJYSwitchButtonUI.this).getSwitch((JYSwitchButton)b, (boolean)true).getPreferredSize().width, ((BasicJYSwitchButtonUI)BasicJYSwitchButtonUI.this).getSwitch((JYSwitchButton)b, (boolean)false).getPreferredSize().width);
            return new Dimension(width, super.getPreferredSize().height);
        }
    }
}

