/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.switchbutton.ui;

import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.switchbutton.ui.BasicJYSwitchButtonUI;
import de.javasoft.switchbutton.ui.painter.JYSwitchButtonPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class SyntheticaJYSwitchButtonUI
extends BasicJYSwitchButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaJYSwitchButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Font f = b.getFont();
        if (f == null || f instanceof UIResource) {
            b.setFont(UIManager.getFont("Label.font"));
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, textRect);
        } else {
            SynthStyle ss = SynthLookAndFeel.getStyle(c, Region.CHECK_BOX);
            SynthContext sc = new SynthContext(c, Region.CHECK_BOX, ss, c.isEnabled() ? 0 : 8);
            Color color = c.isEnabled() ? c.getForeground() : ss.getColor(sc, ColorType.TEXT_FOREGROUND);
            g.setColor(color);
            ss.getGraphicsUtils(sc).paintText(sc, g, text, textRect.x, textRect.y, ((AbstractButton)c).getDisplayedMnemonicIndex());
        }
    }

    @Override
    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h) {
        SyntheticaState state = this.createState(c, ((AbstractButton)c).isSelected());
        JYSwitchButtonPainter.getInstance().paintBackground(c, state, g, x, y, w, h);
    }

    @Override
    protected void paintSwitchBackground(JComponent c, boolean selected, Graphics g, int x, int y, int w, int h) {
        JYSwitchButtonPainter.getInstance().paintSwitchBackground(c, this.createState(c, selected), g, x, y, w, h);
    }

    @Override
    protected void paintSwitch(JComponent c, boolean selected, Graphics g, int x, int y, int w, int h) {
        JYSwitchButtonPainter.getInstance().paintSwitch(c, this.createState(c, selected), g, x, y, w, h);
    }

    private SyntheticaState createState(JComponent c, boolean selected) {
        AbstractButton b = (AbstractButton)c;
        SyntheticaState state = new SyntheticaState();
        if (selected) {
            state.setState(SyntheticaState.State.SELECTED);
        }
        if (b.hasFocus()) {
            state.setState(SyntheticaState.State.FOCUSED);
        }
        if (b.getModel().isRollover()) {
            state.setState(SyntheticaState.State.HOVER);
        }
        if (!b.isEnabled()) {
            state.setState(SyntheticaState.State.DISABLED);
        }
        return state;
    }
}

