/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui.controls;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.tabpane.ui.BasicJYTabbedPaneUI;
import de.javasoft.tabpane.ui.controls.TabOverviewPreviewPanel;
import de.javasoft.tabpane.ui.painter.JYTabbedPanePainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class Tab
extends JPanel
implements SwingConstants {
    private static final long serialVersionUID = 5244598924076258816L;
    private BasicJYTabbedPaneUI ui;
    private BasicJYTabbedPaneUI.TabsPanel tabsPanel;
    private JPanel tabContentPanel;
    private JButton closeButton;
    private static FocusListener repaintFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent evt) {
            ((Tab)evt.getSource()).repaint();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            ((Tab)evt.getSource()).repaint();
        }
    };

    public Tab(JYTabbedPane tabPane, JComponent c) {
        this.ui = (BasicJYTabbedPaneUI)tabPane.getUI();
        this.tabsPanel = this.ui.getTabsPanel();
        this.setOpaque(false);
        this.setName("JYTabbedPane.Tab");
        this.setLayout(new OverlayLayout(this));
        this.setFocusable(tabPane.getTabsFocusable());
        this.tabContentPanel = new JPanel(new BorderLayout());
        this.tabContentPanel.setName("JYTabbedPane.TabContentPanel");
        this.tabContentPanel.setOpaque(false);
        this.closeButton = this.createCloseButton();
        int placement = tabPane.getTabPlacement();
        if (!tabPane.getTabRotationEnabled().booleanValue()) {
            placement = 1;
        }
        if (SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tab.reversedCloseButtonPlacement", (Component)tabPane, (boolean)false)) {
            this.tabContentPanel.add((Component)this.closeButton, placement == 1 || placement == 3 ? "Before" : (placement == 2 ? "Last" : "First"));
        } else {
            this.tabContentPanel.add((Component)this.closeButton, placement == 1 || placement == 3 ? "After" : (placement == 2 ? "First" : "Last"));
        }
        super.add(this.tabContentPanel);
        if (c != null) {
            this.setComponent(c);
        }
        this.applyComponentOrientation(tabPane.getComponentOrientation());
        String next = "selectNextTab";
        this.getActionMap().put(next, new SelectNextTabAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), next);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), next);
        String prev = "selectPreviousTab";
        this.getActionMap().put(prev, new SelectPreviousTabAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), prev);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), prev);
        String space = "selectTab";
        this.getActionMap().put(space, new SelectTabAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), space);
        this.addFocusListener(repaintFocusListener);
    }

    JPanel getContentPanel() {
        return this.tabContentPanel;
    }

    public JYTabbedPane getTabbedPane() {
        return this.ui.getTabbedPane();
    }

    private JButton createCloseButton() {
        Action a = this.getTabbedPane().getActionMap().get("closeTab");
        JButton b = this.ui.getButtonFactory().createCloseTabButton(this.getTabbedPane(), this, a);
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JYTabbedPane tabPane = Tab.this.getTabbedPane();
                Point p = SwingUtilities.convertPoint((Component)evt.getSource(), evt.getX(), evt.getY(), tabPane);
                MouseEvent me = new MouseEvent(tabPane, evt.getID(), evt.getWhen(), evt.getModifiersEx(), p.x, p.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                Tab.this.getTabbedPane().dispatchEvent(me);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
            }
        });
        return b;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int tabIndex = this.getTabIndex();
        if (tabIndex < 0) {
            return;
        }
        JYTabbedPane tabPane = this.getTabbedPane();
        super.setBounds(x, y, width, height);
        this.ui.assureRectsCreated(this.tabsPanel.getTabCount());
        Rectangle r = SwingUtilities.convertRectangle(this.tabsPanel, this.getBounds(), tabPane);
        this.tabsPanel.setTabRect(tabIndex, r.x, r.y, r.width, r.height);
    }

    public int getTabIndex() {
        int index = -1;
        if (this.getParent() == null) {
            return index;
        }
        return ((BasicJYTabbedPaneUI.TabsPanel)this.getParent()).getTabIndex(this);
    }

    public boolean isSelected() {
        return this.getTabbedPane().getSelectedIndex() == this.getTabIndex();
    }

    @Override
    public boolean isEnabled() {
        JYTabbedPane tabPane = this.getTabbedPane();
        int index = this.getTabIndex();
        return index >= 0 && index < tabPane.getTabCount() ? tabPane.isEnabledAt(index) : super.isEnabled();
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JComponent getComponent() {
        return (JComponent)((BorderLayout)this.tabContentPanel.getLayout()).getLayoutComponent("Center");
    }

    public void setComponent(JComponent c) {
        JComponent oldC = this.getComponent();
        if (oldC != null) {
            this.tabContentPanel.remove(oldC);
        }
        this.tabContentPanel.add((Component)c, "Center");
    }

    @Override
    public float getAlignmentX() {
        JYTabbedPane tabPane = this.getTabbedPane();
        int placement = tabPane.getTabPlacement();
        boolean ltr = tabPane.getComponentOrientation().isLeftToRight();
        return placement == 2 && ltr || placement == 4 && !ltr ? 1.0f : 0.0f;
    }

    @Override
    public float getAlignmentY() {
        return this.getTabbedPane().getTabPlacement() == 1 ? 1.0f : 0.0f;
    }

    @Override
    public Component add(Component comp) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    @Override
    public Component add(Component comp, int index) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException("Use Tab.setComponent(JComponent c)");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        JYTabbedPane tabPane = this.getTabbedPane();
        boolean horizontal = tabPane.getTabPlacement() == 1 || tabPane.getTabPlacement() == 3;
        int min = tabPane.getMinimumTabSize();
        int max = tabPane.getMaximumTabSize();
        if (horizontal && min > 0 && dim.width < min) {
            dim.width = min;
        } else if (!horizontal && min > 0 && dim.height < min) {
            dim.height = min;
        }
        if (horizontal && max > 0 && dim.width > max) {
            dim.width = max;
        } else if (!horizontal && max > 0 && dim.height > max) {
            dim.height = max;
        }
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = this.getPreferredSize();
        int placement = this.getTabbedPane().getTabPlacement();
        if (placement == 1 || placement == 3) {
            for (Component component : this.tabsPanel.getTabs()) {
                dim.height = Math.max(dim.height, component.getPreferredSize().height);
            }
            if (this.getTabbedPane().getTabsStretchedEnabled().booleanValue()) {
                dim.width = 0x1FFFFFFF;
            }
        } else {
            for (Component component : this.tabsPanel.getTabs()) {
                dim.width = Math.max(dim.width, component.getPreferredSize().width);
            }
            if (this.getTabbedPane().getTabsStretchedEnabled().booleanValue()) {
                dim.height = 0x1FFFFFFF;
            }
        }
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Integer hoverIndex;
        super.paintComponent(g);
        JYTabbedPane tabPane = this.getTabbedPane();
        boolean ltr = tabPane.getComponentOrientation().isLeftToRight();
        int tabPlacement = tabPane.getTabPlacement();
        if (this.ui.isVerticalTabPlacement() && !ltr) {
            tabPlacement = tabPlacement == 2 ? 4 : 2;
        }
        int position = -1;
        if (this.tabsPanel.getFirstTab() == this && this.tabsPanel.getLastTab() == this) {
            position = tabPlacement == 1 || tabPlacement == 3 ? 2 : 5;
        } else if (this.tabsPanel.getFirstTab() == this) {
            position = tabPlacement == 1 || tabPlacement == 3 ? (ltr ? 0 : 1) : 3;
        } else if (this.tabsPanel.getLastTab() == this) {
            position = tabPlacement == 1 || tabPlacement == 3 ? (ltr ? 1 : 0) : 4;
        }
        int angle = SyntheticaLookAndFeel.getBoolean((String)"Synthetica.tabbedPane.tab.styleIsRotated", (Component)tabPane) ? 0 : this.ui.placementToRotation(this, tabPlacement).toAngle();
        int w = angle == 0 ? this.getWidth() : this.getHeight();
        int h = angle == 0 ? this.getHeight() : this.getWidth();
        int index = this.getTabIndex();
        SyntheticaState state = new SyntheticaState();
        if (!tabPane.isEnabledAt(index)) {
            state.setState(SyntheticaState.State.DISABLED);
        }
        if (index == tabPane.getSelectedIndex()) {
            state.setState(SyntheticaState.State.SELECTED);
        }
        if ((hoverIndex = (Integer)tabPane.getClientProperty("Synthetica.MOUSE_OVER")) != null && index == hoverIndex) {
            state.setState(SyntheticaState.State.HOVER);
        }
        if (this.hasFocus()) {
            state.setState(SyntheticaState.State.FOCUSED);
        }
        int focusPlacement = tabPlacement == 3 ? 3 : (tabPane.getTabRotationEnabled() != false ? 1 : tabPlacement);
        tabPane.putClientProperty("JTabbedPane.focusPlacement", focusPlacement);
        if ((tabPane.getTabStyle() != JYTabbedPane.TabStyle.SELECTED_TAB_ONLY || state.isSet(SyntheticaState.State.SELECTED)) && (tabPane.getTabStyle() != JYTabbedPane.TabStyle.TABS_ON_HOVER || state.isSet(SyntheticaState.State.SELECTED) || state.isSet(SyntheticaState.State.HOVER))) {
            SynthContext sc = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                sc = new SynthContext(tabPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(tabPane, Region.TABBED_PANE), 0);
            }
            JYTabbedPanePainter.getInstance(sc).paintTabbedPaneTab(tabPane, state, index, tabPlacement, position, angle, g, 0, 0, w, h);
        }
    }

    public static class CloseTabAction
    extends AbstractAction {
        private static final long serialVersionUID = -5930144793277991373L;

        public CloseTabAction() {
            this.putValue("ShortDescription", UIManager.get("JYTabbedPane.closeButton.toolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractButton closeButton = (AbstractButton)evt.getSource();
            Container cont = closeButton.getParent().getParent();
            JYTabbedPane tabPane = null;
            if (cont instanceof Tab) {
                tabPane = ((Tab)cont).getTabbedPane();
            } else if (cont instanceof TabOverviewPreviewPanel) {
                tabPane = ((TabOverviewPreviewPanel)cont).getTabbedPane();
            }
            int tabIndex = this.getClosingTabIndex(cont);
            if (tabPane != null && tabIndex >= 0) {
                ((JTabbedPane)tabPane).removeTabAt(tabIndex);
            }
        }

        protected int getClosingTabIndex(ActionEvent evt) {
            AbstractButton closeButton = (AbstractButton)evt.getSource();
            Container cont = closeButton.getParent().getParent();
            return this.getClosingTabIndex(cont);
        }

        private int getClosingTabIndex(Container cont) {
            int tabIndex = -1;
            if (cont instanceof Tab) {
                tabIndex = ((Tab)cont).getTabIndex();
            } else if (cont instanceof TabOverviewPreviewPanel) {
                tabIndex = ((TabOverviewPreviewPanel)cont).getTabIndex();
            }
            return tabIndex;
        }
    }

    static class SelectNextTabAction
    extends AbstractAction {
        private static final long serialVersionUID = -3862735253975360860L;

        SelectNextTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JYTabbedPane tabPane = ((Tab)evt.getSource()).getTabbedPane();
            boolean ltr = tabPane.getComponentOrientation().isLeftToRight();
            boolean vertical = tabPane.getTabPlacement() == 2 || tabPane.getTabPlacement() == 4;
            Action a = tabPane.getActionMap().get(ltr || vertical ? "navigateNext" : "navigatePrevious");
            a.actionPerformed(new ActionEvent(tabPane, evt.getID(), evt.getActionCommand(), evt.getWhen(), evt.getModifiers()));
        }
    }

    static class SelectPreviousTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 5033780496276748010L;

        SelectPreviousTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JYTabbedPane tabPane = ((Tab)evt.getSource()).getTabbedPane();
            boolean ltr = tabPane.getComponentOrientation().isLeftToRight();
            boolean vertical = tabPane.getTabPlacement() == 2 || tabPane.getTabPlacement() == 4;
            Action a = tabPane.getActionMap().get(ltr || vertical ? "navigatePrevious" : "navigateNext");
            a.actionPerformed(new ActionEvent(tabPane, evt.getID(), evt.getActionCommand(), evt.getWhen(), evt.getModifiers()));
        }
    }

    static class SelectTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 4456899129539865293L;

        SelectTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JYTabbedPane tabPane = ((Tab)evt.getSource()).getTabbedPane();
            int tabIndex = ((Tab)evt.getSource()).getTabIndex();
            if (tabIndex != tabPane.getSelectedIndex()) {
                tabPane.setSelectedIndex(tabIndex);
            }
        }
    }
}

