/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class JYMenu
extends JMenu {
    private static final long serialVersionUID = 3366982019967888919L;

    public JYMenu() {
        this("");
    }

    public JYMenu(String s) {
        super(s);
    }

    public JYMenu(Action a) {
        this();
        this.setAction(a);
    }

    @Override
    protected Point getPopupMenuOrigin() {
        Point p = super.getPopupMenuOrigin();
        int x = p.x;
        int y = p.y;
        JPopupMenu popup = this.getPopupMenu();
        Point position = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsConfiguration dgc;
            GraphicsDevice gd = graphicsDeviceArray[n2];
            if (gd.getType() == 0 && (dgc = gd.getDefaultConfiguration()).getBounds().contains(position)) {
                gc = dgc;
                break;
            }
            ++n2;
        }
        screenBounds = gc.getBounds();
        Insets screenInsets = toolkit.getScreenInsets(gc);
        position.x -= Math.abs(screenInsets.left);
        position.y -= Math.abs(screenInsets.top);
        screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
        screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
        if (!(this.getParent() instanceof JMenu)) {
            int xOffset = UIManager.getInt("Menu.submenuPopupOffsetX");
            int yOffset = UIManager.getInt("Menu.submenuPopupOffsetY");
            Dimension pSize = popup.getPreferredSize();
            Dimension mSize = this.getSize();
            if (this.getComponentOrientation().isLeftToRight()) {
                x = mSize.width + xOffset;
                if (position.x + x + pSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - mSize.width < 2 * (position.x - screenBounds.x)) {
                    x = 0 - xOffset - pSize.width;
                }
            } else {
                x = -xOffset - pSize.width;
                if (position.x + x < screenBounds.x && screenBounds.width - mSize.width > 2 * (position.x - screenBounds.x)) {
                    x = mSize.width + xOffset;
                }
            }
            if (position.y + (y = yOffset) + pSize.height >= screenBounds.height + screenBounds.y && screenBounds.height - mSize.height < 2 * (position.y - screenBounds.y)) {
                y = mSize.height - yOffset - pSize.height;
            }
        }
        return new Point(x, y);
    }
}

