/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.AbstractButtonView;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.HighlightFilter;
import com.macrofocus.common.logging.Logging;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;

public final class DualImageButtonView
extends AbstractButtonView {
    private ButtonModel buttonModel;
    private Image buttonOnImage;
    private Image buttonOffImage;
    private Image buttonOnFocusImage;
    private Image buttonOffFocusImage;
    private Image buttonOnDisabledImage;
    private Image buttonOffDisabledImage;
    private int focusOnMode;
    private int focusOffMode;
    private int disabledOnMode;
    private int disabledOffMode;

    public DualImageButtonView(ButtonModel button_model, Image button_on_image, Image button_off_image, int focus_on_mode, int focus_off_mode, int disabled_on_mode, int disabled_off_mode) {
        super(button_model);
        this.buttonModel = button_model;
        this.focusOnMode = focus_on_mode;
        this.focusOffMode = focus_off_mode;
        this.disabledOnMode = disabled_on_mode;
        this.disabledOffMode = disabled_off_mode;
        this.buttonOnImage = button_on_image;
        this.buttonOffImage = button_off_image;
        this.buttonOnFocusImage = this.createButtonImage(this.buttonOnImage, this.focusOnMode);
        this.buttonOffFocusImage = this.createButtonImage(this.buttonOffImage, this.focusOffMode);
        this.buttonOnDisabledImage = this.createButtonImage(this.buttonOnImage, this.disabledOnMode);
        this.buttonOffDisabledImage = this.createButtonImage(this.buttonOffImage, this.disabledOffMode);
        MediaTracker tracker = new MediaTracker(this);
        try {
            tracker.addImage(this.buttonOnImage, 0);
            tracker.addImage(this.buttonOffImage, 1);
            tracker.addImage(this.buttonOnFocusImage, 2);
            tracker.addImage(this.buttonOffFocusImage, 3);
            tracker.addImage(this.buttonOnDisabledImage, 4);
            tracker.addImage(this.buttonOffDisabledImage, 5);
            tracker.waitForID(0);
            tracker.waitForID(1);
            tracker.waitForID(2);
            tracker.waitForID(3);
            tracker.waitForID(4);
            tracker.waitForID(5);
        }
        catch (InterruptedException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    private Image createButtonImage(Image plain_image, int mode) {
        Image button_image;
        switch (mode) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                HighlightFilter filter = new HighlightFilter(mode);
                FilteredImageSource producer = new FilteredImageSource(plain_image.getSource(), filter);
                button_image = this.createImage(producer);
                break;
            }
            default: {
                button_image = plain_image;
            }
        }
        return button_image;
    }

    @Override
    protected void drawButtonUp(Graphics g, boolean has_focus) {
        if (this.buttonModel.isEnabled()) {
            if (has_focus) {
                switch (this.focusOffMode) {
                    case 4: {
                        g.drawImage(this.buttonOffImage, 0, 0, this);
                        g.setColor(Color.red);
                        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                        break;
                    }
                    default: {
                        g.drawImage(this.buttonOffFocusImage, 0, 0, this);
                        break;
                    }
                }
            } else {
                g.drawImage(this.buttonOffImage, 0, 0, this);
            }
        } else {
            switch (this.disabledOffMode) {
                case 4: {
                    g.drawImage(this.buttonOffImage, 0, 0, this);
                    g.setColor(Color.red);
                    g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                    break;
                }
                default: {
                    g.drawImage(this.buttonOffDisabledImage, 0, 0, this);
                }
            }
        }
    }

    @Override
    protected void drawButtonDown(Graphics g, boolean has_focus) {
        if (this.buttonModel.isEnabled()) {
            if (has_focus) {
                switch (this.focusOnMode) {
                    case 4: {
                        g.drawImage(this.buttonOnImage, 0, 0, this);
                        g.setColor(Color.red);
                        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                        break;
                    }
                    default: {
                        g.drawImage(this.buttonOnFocusImage, 0, 0, this);
                        break;
                    }
                }
            } else {
                g.drawImage(this.buttonOnImage, 0, 0, this);
            }
        } else {
            switch (this.disabledOnMode) {
                case 4: {
                    g.drawImage(this.buttonOnImage, 0, 0, this);
                    g.setColor(Color.red);
                    g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                    break;
                }
                default: {
                    g.drawImage(this.buttonOnDisabledImage, 0, 0, this);
                }
            }
        }
    }
}

