/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.AbstractButtonView;
import com.macrofocus.button.ButtonModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public final class ImageButtonView
extends AbstractButtonView {
    private Image buttonImage;
    private int insetLeft;
    private int insetRight;
    private int insetTop;
    private int insetBottom;

    public ImageButtonView(ButtonModel button_model, Image button_image, int inset_left, int inset_right, int inset_top, int inset_bottom) {
        super(button_model);
        this.buttonImage = button_image;
        this.insetLeft = inset_left;
        this.insetRight = inset_right;
        this.insetTop = inset_top;
        this.insetBottom = inset_bottom;
    }

    @Override
    protected void drawButtonUp(Graphics g, boolean has_focus) {
        g.drawImage(this.buttonImage, 0, 0, this);
        if (has_focus) {
            g.setColor(Color.red);
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }

    @Override
    protected void drawButtonDown(Graphics g, boolean has_focus) {
        int x1 = this.insetLeft;
        int x2 = this.getSize().width - this.insetRight;
        int y1 = this.insetTop;
        int y2 = this.getSize().height - this.insetBottom;
        int shift = 1;
        g.drawImage(this.buttonImage, x1 + shift, y1 + shift, x2 + shift, y2 + shift, x1, y1, x2, y2, this);
        g.setColor(Color.gray);
        g.drawRect(x1 + shift - 1, y1 + shift - 1, x2 - x1 + 1, y2 - y1 + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.buttonImage.getWidth(this) + this.insetLeft + this.insetRight, this.buttonImage.getHeight(this) + this.insetTop + this.insetBottom);
    }
}

