/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button.plaf;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class FlatButtonUI
extends BasicButtonUI {
    private final PropertiesModel propertiesModel;
    private int minimumWidth;
    private int minimumHeight;
    private Color backgroundColor;
    private Color textColor;
    private Font font = new Font("Helvetica", 0, 12);
    private final String name;
    private int align = 0;
    private static int ALIGN_LEFT = -1;
    private static int ALIGN_CENTER = 0;
    private static int ALIGN_RIGHT = 1;

    public FlatButtonUI(PropertiesModel propertiesModel) {
        this(null, propertiesModel);
    }

    public FlatButtonUI(String name, final PropertiesModel propertiesModel) {
        this.propertiesModel = propertiesModel;
        this.name = name;
        this.font = UIManager.getFont("Tree.font");
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                FlatButtonUI.this.updateProperties(propertiesModel);
            }
        });
    }

    public static ComponentUI createUI(JComponent c) {
        return new FlatButtonUI(null);
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(null);
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new SimpleButtonListener(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = b.getSize();
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, size.width, size.height);
        g.setFont(this.font);
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(this.textColor);
        int maximumWidth = fontMetrics.stringWidth(b.getText());
        int x = this.align == ALIGN_LEFT || size.width < maximumWidth ? 0 : (this.align == ALIGN_RIGHT ? size.width - maximumWidth : (size.width - maximumWidth) / 2);
        g.drawString(b.getText(), x, fontMetrics.getMaxAscent());
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        if (this.name == null) {
            this.backgroundColor = propertiesModel.getColor("buttonui.backgroundColor");
            this.textColor = propertiesModel.getColor("buttonui.textColor");
        } else {
            this.backgroundColor = propertiesModel.getColor("buttonui." + this.name + ".backgroundColor");
            this.textColor = propertiesModel.getColor("buttonui." + this.name + ".textColor");
        }
        if (propertiesModel.isAvailable("buttonui." + this.name + ".align")) {
            this.align = (Integer)propertiesModel.getValue("buttonui." + this.name + ".align");
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        FontMetrics fontMetrics = b.getFontMetrics(this.font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        this.minimumWidth = fontMetrics.stringWidth(b.getText().substring(0, 1));
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        FontMetrics fontMetrics = b.getFontMetrics(this.font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        int preferredWidth = fontMetrics.stringWidth(b.getText());
        return new Dimension(preferredWidth, this.minimumHeight);
    }

    class SimpleButtonListener
    extends BasicButtonListener {
        public SimpleButtonListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }
    }
}

