/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button.plaf;

import com.macrofocus.button.plaf.SimpleButtonBorder;
import com.macrofocus.font.FontModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class SimpleButtonUI
extends BasicButtonUI {
    private final PropertiesModel propertiesModel;
    private int minimumWidth;
    private int minimumHeight;
    private Color backgroundColor;
    private Color textColor;
    private Font font = UIManager.getFont("Tree.font");
    private final String name;

    public SimpleButtonUI(PropertiesModel propertiesModel) {
        this(null, propertiesModel);
    }

    public SimpleButtonUI(String name, final PropertiesModel propertiesModel) {
        this.propertiesModel = propertiesModel;
        this.name = name;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                SimpleButtonUI.this.updateProperties(propertiesModel);
            }
        });
    }

    public static ComponentUI createUI(JComponent c) {
        return new SimpleButtonUI(null);
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(new SimpleButtonBorder(this.propertiesModel));
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new SimpleButtonListener(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean isPressed = model.isPressed() && model.isArmed() || model.isSelected();
        Dimension size = b.getSize();
        if (c.getBackground() != null) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(this.backgroundColor);
        }
        g.fillRect(0, 0, size.width, size.height);
        if (b.getText() != null) {
            g.setFont(this.font);
            FontMetrics fontMetrics = g.getFontMetrics();
            if (isPressed) {
                g.setColor(this.textColor);
                g.drawString(b.getText(), 3, fontMetrics.getMaxAscent() + 1);
            } else {
                g.setColor(this.textColor);
                g.drawString(b.getText(), 2, fontMetrics.getMaxAscent());
            }
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        if (this.name == null) {
            this.backgroundColor = propertiesModel.getColor("buttonui.backgroundColor");
            this.textColor = propertiesModel.getColor("buttonui.textColor");
        } else {
            this.backgroundColor = propertiesModel.getColor("buttonui." + this.name + ".backgroundColor");
            this.textColor = propertiesModel.getColor("buttonui." + this.name + ".textColor");
        }
        if (propertiesModel.isAvailable("buttonui." + this.name + ".font")) {
            this.font = ((FontModel)propertiesModel.getValue("buttonui." + this.name + ".font")).getFont();
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (this.font != null) {
            FontMetrics fontMetrics = b.getFontMetrics(this.font);
            this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading() + 3;
            this.minimumWidth = b.getText() != null ? fontMetrics.stringWidth(b.getText()) + 6 : 6;
            return new Dimension(this.minimumWidth, this.minimumHeight);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        FontMetrics fontMetrics = b.getFontMetrics(this.font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading() + 3;
        this.minimumWidth = b.getText() != null ? fontMetrics.stringWidth(b.getText()) + 6 : 6;
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    class SimpleButtonListener
    extends BasicButtonListener {
        public SimpleButtonListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }
    }
}

