/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.macrofocus.colormap.ColorMap;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.InvalidValueException;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.palette.CustomPalette;
import com.macrofocus.palette.InterpolatedPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public class ColorMapState {
    public static void loadCategorical(Class columnClass, Element child, MutableColorMap colorMap) {
        if (colorMap != null) {
            String missingValuesColor;
            String saturation;
            colorMap.clearAssignedColor();
            Elements entries = child.getChildElements();
            for (int i = 0; i < entries.size(); ++i) {
                Object o;
                Element entry = entries.get(i);
                if (!entry.getLocalName().equals("Entry")) continue;
                String value = entry.getAttributeValue("value");
                try {
                    DefaultTypemapModel typemapModel = new DefaultTypemapModel();
                    TypemapModel.Builder builder = typemapModel.getBuilder(columnClass);
                    o = builder.create(value);
                }
                catch (InvalidValueException | NullPointerException e) {
                    e.printStackTrace();
                    o = value;
                }
                CPColor color = SwingFactory.getInstance().createRGBColor(entry.getAttributeValue("color"));
                colorMap.setColor(o, color);
            }
            String brightness = child.getAttributeValue("brightness");
            if (brightness != null) {
                colorMap.setBrightness(Integer.valueOf(brightness).intValue());
            }
            if ((saturation = child.getAttributeValue("saturation")) != null) {
                colorMap.setSaturation(Integer.valueOf(saturation).intValue());
            }
            if ((missingValuesColor = child.getAttributeValue("missingValuesColor")) != null) {
                colorMap.setNullColor(SwingFactory.getInstance().createRGBColor(missingValuesColor));
            }
        }
    }

    public static void loadCustom(Number min, Number max, Element child, MutableColorMap colorMap) {
        if (colorMap != null) {
            String missingValuesColor;
            String underflowColor;
            String overflowColor;
            String saturation;
            String brightness;
            CustomPalette palette = (CustomPalette)colorMap.getPalette();
            String mode = child.getAttributeValue("mode");
            if (mode != null) {
                palette.setMode(CustomPalette.Mode.valueOf((String)mode));
            }
            if ((brightness = child.getAttributeValue("brightness")) != null) {
                colorMap.setBrightness(Integer.valueOf(brightness).intValue());
            }
            if ((saturation = child.getAttributeValue("saturation")) != null) {
                colorMap.setSaturation(Integer.valueOf(saturation).intValue());
            }
            if ((overflowColor = child.getAttributeValue("overflowColor")) != null) {
                colorMap.setOverColor(SwingFactory.getInstance().createRGBColor(overflowColor));
            }
            if ((underflowColor = child.getAttributeValue("underflowColor")) != null) {
                colorMap.setUnderColor(SwingFactory.getInstance().createRGBColor(underflowColor));
            }
            if ((missingValuesColor = child.getAttributeValue("missingValuesColor")) != null) {
                colorMap.setNullColor(SwingFactory.getInstance().createRGBColor(missingValuesColor));
            }
            ArrayList<InterpolatedPalette.Entry> list = new ArrayList<InterpolatedPalette.Entry>();
            Elements entries = child.getChildElements();
            for (int i = 0; i < entries.size(); ++i) {
                Element entry = entries.get(i);
                if (!entry.getLocalName().equals("Entry")) continue;
                double fraction = Double.valueOf(entry.getAttributeValue("fraction"));
                String absoluteString = entry.getAttributeValue("absolute");
                if (absoluteString != null) {
                    double absolute = Double.valueOf(absoluteString);
                    if (min != null && max != null) {
                        fraction = ColorMapState.getFraction(absolute, min, max);
                    }
                }
                CPColor color = SwingFactory.getInstance().createRGBColor(entry.getAttributeValue("color"));
                list.add(new InterpolatedPalette.Entry(fraction, color));
            }
            palette.setEntries(list);
        }
    }

    public static void loadPredefined(Element child, MutableColorMap colorMap) {
        if (colorMap != null) {
            String missingValuesColor;
            String underflowColor;
            String overflowColor;
            String saturation;
            String brightness;
            String inverted;
            String numberOfSteps;
            String maximum;
            String minimum;
            String palette = child.getAttributeValue("palette");
            if (palette != null) {
                colorMap.setPalette((MutablePalette)SwingPaletteFactory.getInstance().get(palette).getPalette());
            }
            if ((minimum = child.getAttributeValue("minimum")) != null) {
                colorMap.getInterval().setStart(Double.valueOf(minimum).doubleValue());
            }
            if ((maximum = child.getAttributeValue("maximum")) != null) {
                colorMap.getInterval().setEnd(Double.valueOf(maximum).doubleValue());
            }
            if ((numberOfSteps = child.getAttributeValue("numberOfSteps")) != null) {
                colorMap.setColorCount(Integer.valueOf(numberOfSteps).intValue());
            }
            if ((inverted = child.getAttributeValue("inverted")) != null) {
                colorMap.setInverted(Boolean.valueOf(inverted).booleanValue());
            }
            if ((brightness = child.getAttributeValue("brightness")) != null) {
                colorMap.setBrightness(Integer.valueOf(brightness).intValue());
            }
            if ((saturation = child.getAttributeValue("saturation")) != null) {
                colorMap.setSaturation(Integer.valueOf(saturation).intValue());
            }
            if ((overflowColor = child.getAttributeValue("overflowColor")) != null) {
                colorMap.setOverColor(SwingFactory.getInstance().createRGBColor(overflowColor));
            }
            if ((underflowColor = child.getAttributeValue("underflowColor")) != null) {
                colorMap.setUnderColor(SwingFactory.getInstance().createRGBColor(underflowColor));
            }
            if ((missingValuesColor = child.getAttributeValue("missingValuesColor")) != null) {
                colorMap.setNullColor(SwingFactory.getInstance().createRGBColor(missingValuesColor));
            }
        }
    }

    public static Element savePredefinedColorMap(ColorMap colorMap) {
        Element colorMapElement = new Element("Colormap");
        colorMapElement.addAttribute(new Attribute("type", "predefined"));
        colorMapElement.addAttribute(new Attribute("palette", SwingPaletteFactory.getInstance().find(colorMap.getPalette()).getName()));
        Interval interval = colorMap.getInterval();
        colorMapElement.addAttribute(new Attribute("minimum", Double.toString(interval.getStart())));
        colorMapElement.addAttribute(new Attribute("maximum", Double.toString(interval.getEnd())));
        colorMapElement.addAttribute(new Attribute("numberOfSteps", Integer.toString(colorMap.getColorCount())));
        colorMapElement.addAttribute(new Attribute("inverted", Boolean.toString(colorMap.isInverted())));
        colorMapElement.addAttribute(new Attribute("brightness", Integer.toString(colorMap.getBrightness())));
        colorMapElement.addAttribute(new Attribute("saturation", Integer.toString(colorMap.getSaturation())));
        colorMapElement.addAttribute(new Attribute("overflowColor", colorMap.getOverflowColor().toHTMLColor()));
        colorMapElement.addAttribute(new Attribute("underflowColor", colorMap.getUnderflowColor().toHTMLColor()));
        colorMapElement.addAttribute(new Attribute("missingValuesColor", colorMap.getNullColor().toHTMLColor()));
        return colorMapElement;
    }

    public static Element saveCustomColorMap(Number min, Number max, ColorMap colorMap) {
        Element colorMapElement = new Element("Colormap");
        colorMapElement.addAttribute(new Attribute("type", "custom"));
        CustomPalette palette = (CustomPalette)colorMap.getPalette();
        colorMapElement.addAttribute(new Attribute("mode", palette.getMode().toString()));
        for (CustomPalette.Entry entry : palette.getEntries()) {
            Element entryElement = new Element("Entry");
            entryElement.addAttribute(new Attribute("fraction", Double.toString(entry.getFraction())));
            if (min != null && max != null) {
                entryElement.addAttribute(new Attribute("absolute", Double.toString(ColorMapState.getAbsolute(entry.getFraction(), min, max))));
            }
            entryElement.addAttribute(new Attribute("color", entry.getColor().toHTMLColor()));
            colorMapElement.appendChild((Node)entryElement);
        }
        colorMapElement.addAttribute(new Attribute("brightness", Integer.toString(colorMap.getBrightness())));
        colorMapElement.addAttribute(new Attribute("saturation", Integer.toString(colorMap.getSaturation())));
        colorMapElement.addAttribute(new Attribute("overflowColor", colorMap.getOverflowColor().toHTMLColor()));
        colorMapElement.addAttribute(new Attribute("underflowColor", colorMap.getUnderflowColor().toHTMLColor()));
        colorMapElement.addAttribute(new Attribute("missingValuesColor", colorMap.getNullColor().toHTMLColor()));
        return colorMapElement;
    }

    public static Element saveCategoricalColorMap(ColorMap colorMap) {
        Element colorMapElement = new Element("Colormap");
        colorMapElement.addAttribute(new Attribute("type", "categorical"));
        for (Object entry : colorMap.getAssignedValues()) {
            Element entryElement = new Element("Entry");
            entryElement.addAttribute(new Attribute("value", entry.toString()));
            entryElement.addAttribute(new Attribute("color", colorMap.getColor(entry).toHTMLColor()));
            colorMapElement.appendChild((Node)entryElement);
        }
        colorMapElement.addAttribute(new Attribute("brightness", Integer.toString(colorMap.getBrightness())));
        colorMapElement.addAttribute(new Attribute("saturation", Integer.toString(colorMap.getSaturation())));
        colorMapElement.addAttribute(new Attribute("missingValuesColor", colorMap.getNullColor().toHTMLColor()));
        return colorMapElement;
    }

    private static double getFraction(double absolute, Number min, Number max) {
        return (absolute - min.doubleValue()) / (max.doubleValue() - min.doubleValue());
    }

    private static double getAbsolute(double fraction, Number min, Number max) {
        return min.doubleValue() + fraction * (max.doubleValue() - min.doubleValue());
    }
}

