/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing;

import com.macrofocus.drawing.AbstractDrawingObjectModel;
import com.macrofocus.drawing.coordinate.CoordinateSystemModel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class PolygonDrawingObjectModel
extends AbstractDrawingObjectModel {
    private double[] xCoord;
    private double[] yCoord;
    private Polygon screenPolygon;
    private int[] xScreen;
    private int[] yScreen;
    private int nPoints;
    private boolean fill;
    private boolean line;

    public PolygonDrawingObjectModel(double[] xCoord, double[] yCoord, boolean fill, boolean line) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.line = line;
        this.fill = fill;
        this.nPoints = xCoord.length < yCoord.length ? xCoord.length : yCoord.length;
        this.xScreen = new int[this.nPoints];
        this.yScreen = new int[this.nPoints];
        this.screenPolygon = new Polygon(this.xScreen, this.yScreen, this.nPoints);
    }

    @Override
    public void draw(Graphics g, CoordinateSystemModel coordinateSystem) {
        Graphics2D g2 = (Graphics2D)g;
        for (int i = 0; i < this.nPoints; ++i) {
            this.screenPolygon.xpoints[i] = coordinateSystem.xWorldToScreen(this.xCoord[i]);
            this.screenPolygon.ypoints[i] = coordinateSystem.yWorldToScreen(this.yCoord[i]);
        }
        g.setColor(this.getColor());
        if (this.line) {
            g2.drawPolyline(this.screenPolygon.xpoints, this.screenPolygon.ypoints, this.screenPolygon.npoints);
        } else if (this.fill) {
            g2.fillPolygon(this.screenPolygon);
            g2.drawPolygon(this.screenPolygon);
        } else {
            g2.drawPolygon(this.screenPolygon);
        }
    }

    public String toString() {
        String contents = "Polygon: ";
        for (int i = 0; i < this.nPoints; ++i) {
            contents = contents + "[" + this.xCoord[i] + "," + this.yCoord[i] + "]";
            if (i >= this.nPoints - 1) continue;
            contents = contents + ",";
        }
        return contents;
    }
}

