/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing.axis;

import com.macrofocus.drawing.axis.AxisEvent;
import com.macrofocus.drawing.axis.AxisListener;
import com.macrofocus.drawing.axis.AxisModel;
import com.macrofocus.drawing.axis.AxisRenderer;
import com.macrofocus.drawing.axis.AxisView;
import com.macrofocus.drawing.axis.VerticalAxisRenderer;
import com.macrofocus.drawing.coordinate.CoordinateSystemModel;
import com.macrofocus.font.FontModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;

public class SimpleAxisView
extends AxisView {
    private final AxisModel axisModel;
    private int orientation;
    private AxisRenderer axisRenderer;
    private boolean drawTickLabels = true;
    private boolean drawRangeTrapezoid = false;
    private int alignment;
    private Font labelFont;
    private int maxLabelWidth = 6;
    private double fullRangeMin;
    private double fullRangeMax;
    private int marginLow;
    private int marginHigh;

    public SimpleAxisView(final AxisModel axisModel, int orientation, final PropertiesModel propertiesModel) {
        this.axisModel = axisModel;
        this.orientation = orientation == 1 || orientation == 2 ? orientation : 2;
        if (orientation == 1) {
            this.alignment = 1;
            this.axisRenderer = null;
        } else {
            this.alignment = 4;
            this.axisRenderer = new VerticalAxisRenderer(axisModel, this, propertiesModel);
        }
        axisModel.addAxisListener(new AxisListener(){

            @Override
            public void rangeChanged(AxisEvent event) {
                SimpleAxisView.this.repaint();
            }

            @Override
            public void fullRangeChanged(AxisEvent event) {
                SimpleAxisView.this.fullRangeMin = axisModel.getFullRangeMin();
                SimpleAxisView.this.fullRangeMax = axisModel.getFullRangeMax();
                SimpleAxisView.this.repaint();
            }
        });
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    SimpleAxisView.this.updateProperties(propertiesModel);
                    SimpleAxisView.this.repaint();
                }
            });
        }
    }

    @Override
    public Dimension getMinimumSize() {
        int height;
        int width;
        CoordinateSystemModel coordinateSystem = this.axisModel.getCoordinateSystemModel();
        int space_for_ticks_and_stuff = 20;
        if (this.orientation == 2) {
            if (this.drawTickLabels) {
                String template = "00000000000000000000";
                String widestLabel = template.substring(0, this.maxLabelWidth);
                width = this.getFontMetrics(this.labelFont).stringWidth(widestLabel) + space_for_ticks_and_stuff;
            } else {
                width = space_for_ticks_and_stuff;
            }
            height = coordinateSystem.getScreenHeight();
        } else {
            width = coordinateSystem.getScreenWidth();
            height = this.getFontMetrics(this.getFont()).getHeight() + space_for_ticks_and_stuff;
        }
        return new Dimension(width, height);
    }

    @Override
    public void paint(Graphics g) {
        this.axisRenderer.drawAxis(g, this.alignment, this.drawRangeTrapezoid, this.fullRangeMin, this.fullRangeMax, this.marginLow, this.marginHigh);
        if (this.drawTickLabels) {
            this.axisRenderer.drawTickLabelsAndMarks(g, this.alignment);
        } else {
            this.axisRenderer.drawTickMarks(g, this.alignment);
        }
    }

    @Override
    public void setDrawTickLabels(boolean drawTickLabels) {
        if (drawTickLabels != this.drawTickLabels) {
            this.drawTickLabels = drawTickLabels;
            this.repaint();
        }
    }

    @Override
    public void setDrawRangeTrapezoid(boolean drawRangeTrapezoid) {
        if (drawRangeTrapezoid != this.drawRangeTrapezoid) {
            this.drawRangeTrapezoid = drawRangeTrapezoid;
            this.repaint();
        }
    }

    @Override
    public void setRangeTrapezoidParameters(double fullRangeMin, double fullRangeMax, int marginLow, int marginHigh) {
        this.fullRangeMin = fullRangeMin;
        this.fullRangeMax = fullRangeMax;
        this.marginLow = marginLow;
        this.marginHigh = marginHigh;
        this.repaint();
    }

    private void initRangeTrapezoid() {
        this.drawRangeTrapezoid = false;
    }

    @Override
    public void setAlignment(int alignment) {
        if (alignment != this.alignment && (this.orientation == 1 && (alignment == 1 || alignment == 2) || this.orientation == 2 && (alignment == 4 || alignment == 3))) {
            this.alignment = alignment;
            this.repaint();
        }
    }

    @Override
    public double getLargestLabelValue() {
        return Double.NaN;
    }

    @Override
    public void setLargestLabelValue(double largestLabelValue) {
    }

    @Override
    public void setWidestLabel(String label) {
    }

    @Override
    public void setMaxLabelWidth(int maxLabelWidth) {
        this.maxLabelWidth = maxLabelWidth;
        if (this.maxLabelWidth > 20) {
            this.maxLabelWidth = 20;
        }
        this.repaint();
    }

    @Override
    public int getMaxLabelWidth() {
        return this.maxLabelWidth;
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        if (propertiesModel != null) {
            this.labelFont = ((FontModel)propertiesModel.getValue(this.getClass(), "labelFont")).getFont();
        }
    }
}

