/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing.zoom;

import com.macrofocus.drawing.zoom.ZoomEvent;
import com.macrofocus.drawing.zoom.ZoomListener;
import com.macrofocus.drawing.zoom.ZoomStrategy;
import java.util.Vector;

public class BifocalLensZoom
implements ZoomStrategy {
    private double focusXWorld = 0.5;
    private double focusYWorld = 0.5;
    private double focusWidthWorld = 0.0;
    private double focusHeightWorld = 0.0;
    private double zoomFactorX;
    private double zoomFactorY;
    private double compressionFactorX;
    private double compressionFactorY;
    private double[] windowBoundariesX = new double[4];
    private double[] windowBoundariesY = new double[4];
    private Vector zoomListeners;

    public BifocalLensZoom() {
        this.computeWindowBoundaries(this.windowBoundariesX, this.focusXWorld, this.focusWidthWorld, this.zoomFactorX);
        this.computeWindowBoundaries(this.windowBoundariesY, this.focusYWorld, this.focusHeightWorld, this.zoomFactorY);
        this.zoomListeners = new Vector();
    }

    public void setZoomFactor(double zoomFactor) {
        if (zoomFactor == this.zoomFactorX && zoomFactor == this.zoomFactorY) {
            return;
        }
        this.zoomFactorX = this.focusWidthWorld * zoomFactor > 1.0 ? 1.0 / this.focusWidthWorld : (this.focusHeightWorld * zoomFactor > 1.0 ? 1.0 / this.focusHeightWorld : zoomFactor);
        this.zoomFactorY = this.zoomFactorX;
        this.computeCompressionFactors();
        this.computeWindowBoundaries(this.windowBoundariesX, this.focusXWorld, this.focusWidthWorld, this.zoomFactorX);
        this.computeWindowBoundaries(this.windowBoundariesY, this.focusYWorld, this.focusHeightWorld, this.zoomFactorY);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setZoomFactorX(double zoomFactor) {
        if (zoomFactor == this.zoomFactorX) {
            return;
        }
        this.zoomFactorX = this.focusWidthWorld * zoomFactor > 1.0 ? 1.0 / this.focusWidthWorld : zoomFactor;
        this.computeCompressionFactors();
        this.computeWindowBoundaries(this.windowBoundariesX, this.focusXWorld, this.focusWidthWorld, this.zoomFactorX);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setZoomFactorY(double zoomFactor) {
        if (zoomFactor == this.zoomFactorY) {
            return;
        }
        this.zoomFactorY = this.focusHeightWorld * zoomFactor > 1.0 ? 1.0 / this.focusHeightWorld : zoomFactor;
        this.computeCompressionFactors();
        this.computeWindowBoundaries(this.windowBoundariesY, this.focusYWorld, this.focusHeightWorld, this.zoomFactorY);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setFocusXWorld(double focusXworld) {
        if (focusXworld == this.focusXWorld) {
            return;
        }
        this.focusXWorld = focusXworld - this.focusWidthWorld / 2.0 < 0.0 ? this.focusWidthWorld / 2.0 : (focusXworld + this.focusWidthWorld / 2.0 > 1.0 ? 1.0 - this.focusWidthWorld / 2.0 : focusXworld);
        this.computeWindowBoundaries(this.windowBoundariesX, focusXworld, this.focusWidthWorld, this.zoomFactorX);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setFocusYWorld(double focusYworld) {
        if (focusYworld == this.focusYWorld) {
            return;
        }
        this.focusYWorld = focusYworld - this.focusHeightWorld / 2.0 < 0.0 ? this.focusHeightWorld / 2.0 : (focusYworld + this.focusHeightWorld / 2.0 > 1.0 ? 1.0 - this.focusHeightWorld / 2.0 : focusYworld);
        this.computeWindowBoundaries(this.windowBoundariesY, focusYworld, this.focusHeightWorld, this.zoomFactorY);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setFocusWidthWorld(double focusWidthWorld) {
        if (focusWidthWorld == this.focusWidthWorld) {
            return;
        }
        this.focusWidthWorld = focusWidthWorld;
        if (this.focusXWorld - focusWidthWorld / 2.0 < 0.0) {
            this.focusXWorld = focusWidthWorld / 2.0;
        } else if (this.focusXWorld + focusWidthWorld / 2.0 > 1.0) {
            this.focusXWorld = 1.0 - focusWidthWorld / 2.0;
        }
        this.computeCompressionFactors();
        this.computeWindowBoundaries(this.windowBoundariesX, this.focusXWorld, focusWidthWorld, this.zoomFactorX);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setFocusHeightWorld(double focusHeightWorld) {
        if (focusHeightWorld == this.focusHeightWorld) {
            return;
        }
        this.focusHeightWorld = focusHeightWorld;
        if (this.focusYWorld - focusHeightWorld / 2.0 < 0.0) {
            this.focusYWorld = focusHeightWorld / 2.0;
        } else if (this.focusYWorld + focusHeightWorld / 2.0 > 1.0) {
            this.focusYWorld = 1.0 - focusHeightWorld / 2.0;
        }
        this.computeCompressionFactors();
        this.computeWindowBoundaries(this.windowBoundariesY, this.focusYWorld, focusHeightWorld, this.zoomFactorY);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setZoomWindowX(double x1, double x2) {
        double width = (x2 - x1) / this.zoomFactorX;
        double focus = x1 * (1.0 - width) / (1.0 - width * this.zoomFactorX) + width / 2.0;
        this.setFocusWidthWorld(width);
        this.setFocusXWorld(focus);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setZoomWindowY(double y1, double y2) {
        double height = (y2 - y1) / this.zoomFactorY;
        double focus = y1 * (1.0 - height) / (1.0 - height * this.zoomFactorY) + height / 2.0;
        this.setFocusHeightWorld(height);
        this.setFocusYWorld(focus);
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    @Override
    public double worldXToZoomedX(double x) {
        if (this.focusWidthWorld <= 0.0) {
            return x;
        }
        return this.focalTransformation(x, false, this.windowBoundariesX[0], this.windowBoundariesX[1], this.windowBoundariesX[2], this.windowBoundariesX[3]);
    }

    @Override
    public double worldYToZoomedY(double y) {
        if (this.focusHeightWorld <= 0.0) {
            return y;
        }
        return this.focalTransformation(y, false, this.windowBoundariesY[0], this.windowBoundariesY[1], this.windowBoundariesY[2], this.windowBoundariesY[3]);
    }

    @Override
    public double zoomedXToWorldX(double x) {
        if (this.focusWidthWorld <= 0.0) {
            return x;
        }
        return this.focalTransformation(x, true, this.windowBoundariesX[2], this.windowBoundariesX[3], this.windowBoundariesX[0], this.windowBoundariesX[1]);
    }

    @Override
    public double zoomedYToWorldY(double y) {
        if (this.focusHeightWorld <= 0.0) {
            return y;
        }
        return this.focalTransformation(y, true, this.windowBoundariesY[2], this.windowBoundariesY[3], this.windowBoundariesY[0], this.windowBoundariesY[1]);
    }

    private double focalTransformation(double value_raw, boolean back_transformation, double window_low_raw, double window_high_raw, double window_low_trans, double window_high_trans) {
        double value_trans = value_raw < window_low_raw ? value_raw / window_low_raw * window_low_trans : (value_raw > window_high_raw ? (value_raw - window_high_raw) / (1.0 - window_high_raw) * (1.0 - window_high_trans) + window_high_trans : (value_raw - window_low_raw) / (window_high_raw - window_low_raw) * (window_high_trans - window_low_trans) + window_low_trans);
        return value_trans;
    }

    private void computeWindowBoundaries(double[] boundaries, double focus_location, double focus_width, double zoom_factor) {
        double low_width_zoom;
        double x1w = focus_location - focus_width / 2.0;
        double x2w = focus_location + focus_width / 2.0;
        double low_width_percentage_world = x1w / (1.0 - focus_width);
        double focus_width_zoom = focus_width * zoom_factor;
        double x1z = low_width_zoom = low_width_percentage_world * (1.0 - focus_width_zoom);
        double x2z = low_width_zoom + focus_width_zoom;
        boundaries[0] = x1w;
        boundaries[1] = x2w;
        boundaries[2] = x1z;
        boundaries[3] = x2z;
    }

    public double getWindowLowX() {
        return this.windowBoundariesX[2];
    }

    public double getWindowHighX() {
        return this.windowBoundariesX[3];
    }

    public double getWindowLowY() {
        return this.windowBoundariesY[2];
    }

    public double getWindowHighY() {
        return this.windowBoundariesY[3];
    }

    public double getFocusXWorld() {
        return this.focusXWorld;
    }

    public double getFocusYWorld() {
        return this.focusYWorld;
    }

    public double getFocusWidthWorld() {
        return this.focusWidthWorld;
    }

    public double getFocusHeightWorld() {
        return this.focusHeightWorld;
    }

    public double getZoomFactor() {
        return this.zoomFactorX;
    }

    public double getZoomFactorX() {
        return this.zoomFactorX;
    }

    public double getZoomFactorY() {
        return this.zoomFactorY;
    }

    private void computeCompressionFactors() {
        this.compressionFactorX = (1.0 - this.zoomFactorX * this.focusWidthWorld) / (1.0 - this.focusWidthWorld);
        this.compressionFactorY = (1.0 - this.zoomFactorY * this.focusHeightWorld) / (1.0 - this.focusHeightWorld);
    }

    public double getCompressionFactorX() {
        return this.compressionFactorX;
    }

    public double getCompressionFactorY() {
        return this.compressionFactorY;
    }

    public boolean isLensActive() {
        return this.focusWidthWorld > 0.0 || this.focusHeightWorld > 0.0;
    }

    @Override
    public void addZoomListener(ZoomListener listener) {
        this.zoomListeners.addElement(listener);
    }

    @Override
    public void removeZoomListener(ZoomListener listener) {
        this.zoomListeners.removeElement(listener);
    }

    private void fireZoomChanged(ZoomEvent event) {
        for (int i = 0; i < this.zoomListeners.size(); ++i) {
            ZoomListener zoomListener = (ZoomListener)this.zoomListeners.elementAt(i);
            zoomListener.zoomChanged(event);
        }
    }

    public String toString() {
        return this.getClass().getName() + " (xw, yw, ww, hw, zfx, zfy): " + this.focusXWorld + ", " + this.focusYWorld + ", " + this.focusWidthWorld + ", " + this.focusHeightWorld + ", " + this.zoomFactorX + ", " + this.zoomFactorY;
    }
}

