/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.graphic;

import com.macrofocus.color.ColorModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.color.SimpleColormapModel;
import com.macrofocus.graphic.AbstractDirectGraphicModel;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class Java2DGraphicModel
extends AbstractDirectGraphicModel {
    private final int height;
    private final int width;
    private final ColormapModel colormapModel;
    private final BufferedImage memoryImage;
    private final Graphics2D g;
    private final Component component;

    public Java2DGraphicModel(Component component, int[] r, int[] g, int[] b, int[] a, int width, int height) {
        this(component, (ColormapModel)new SimpleColormapModel(r, g, b, a), width, height);
    }

    public Java2DGraphicModel(Component component, ColormapModel colormapModel, int width, int height) {
        this.width = width;
        this.height = height;
        this.component = component;
        this.colormapModel = colormapModel;
        this.memoryImage = new BufferedImage(width, height, 1);
        this.g = this.memoryImage.createGraphics();
    }

    @Override
    public void drawPoint(int x, int y, ColorModel colorModel) {
        this.memoryImage.setRGB(x, y, colorModel.getRGB());
    }

    @Override
    public void drawHorizontalLine(int x1, int x2, int y, ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.drawLine(x1, y, x2 - x1, y);
    }

    @Override
    public void drawRect(int x1, int y1, int x2, int y2, ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.drawRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void fillRect(int x1, int y1, int x2, int y2, ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.fillRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void drawBitmap(byte[] bit_map, int bit_map_width, int bit_map_height, int x, int y) {
    }

    @Override
    public void clearImage(int color) {
        this.clearImage(this.colormapModel.getColorModel(color));
    }

    @Override
    public void clearImage(ColorModel color) {
        this.g.setColor(color.getColor());
        this.g.fillRect(0, 0, this.width, this.height);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getRed(int x, int y) {
        return 0;
    }

    public int getGreen(int x, int y) {
        return 0;
    }

    public int getBlue(int x, int y) {
        return 0;
    }

    public int getAlpha(int x, int y) {
        return 0;
    }

    @Override
    public ColormapModel getColormapModel() {
        return this.colormapModel;
    }

    @Override
    public Image getImage() {
        return this.memoryImage;
    }

    @Override
    public synchronized void newPixels() {
        this.component.imageUpdate(this.getImage(), 32, 0, 0, this.width, this.height);
    }

    @Override
    public void dispose() {
        this.memoryImage.flush();
    }
}

