/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.graphic;

import com.macrofocus.color.ColorModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.graphic.AbstractDirectGraphicModel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class TransparentInvertedRasterGraphicModel
extends AbstractDirectGraphicModel {
    private final int height;
    private final int width;
    private final ColormapModel colormapModel;
    private BufferedImage memoryImage;
    private Graphics g;
    private Component component;

    public TransparentInvertedRasterGraphicModel(Component component, ColormapModel colormapModel, int width, int height, ColorModel background) {
        this.width = width;
        this.height = height;
        this.component = component;
        this.colormapModel = colormapModel;
        this.memoryImage = component.getGraphicsConfiguration().createCompatibleImage(width, height, 2);
        this.g = this.memoryImage.getGraphics();
    }

    @Override
    public final void drawPoint(int x, int y, ColorModel colorModel) {
        this.memoryImage.setRGB(x, y, colorModel.getRGBA());
    }

    @Override
    public void drawBitmap(byte[] bit_map, int bit_map_width, int bit_map_height, int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearImage(ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.fillRect(0, 0, this.width, this.height);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Image getImage() {
        return this.memoryImage;
    }

    @Override
    public ColormapModel getColormapModel() {
        return this.colormapModel;
    }

    @Override
    public void newPixels() {
        this.component.repaint();
    }

    @Override
    public void dispose() {
        this.g.dispose();
        this.memoryImage.flush();
        this.component = null;
        this.g = null;
        this.memoryImage = null;
    }
}

