/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.CPFontMetrics;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.IHeadless;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingIHeadless;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.guide.AbstractSwingGuide;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.NumberAxis;
import com.macrofocus.plot.guide.NumberTick;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisListener;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class YNumberCoordinateAxisGuide
extends AbstractSwingGuide {
    private final CPColor labelColor = new SwingColor(Color.black);
    private final CPColor frameColor = new SwingColor(215, 215, 211);
    private final Type type;
    private final CoordinateAxisListener coordinateAxisListener = new CoordinateAxisListener(){

        @Override
        public void rangeChanged(CoordinateAxisEvent e) {
            YNumberCoordinateAxisGuide.this.repaint();
            YNumberCoordinateAxisGuide.this.invalidate();
            if (YNumberCoordinateAxisGuide.this.panel != null) {
                YNumberCoordinateAxisGuide.this.panel.valideAxis();
            }
        }
    };
    private CoordinateAxisModel coordinateAxis;
    private ValueAxis axis;
    private CPFormat format;
    private CPColor gridLinesColor = new SwingColor(199, 199, 196);
    private boolean drawFrame = false;
    private AxisPlotPanel panel;

    public YNumberCoordinateAxisGuide(Type type, CoordinateAxisModel coordinateAxis) {
        this(type);
        this.setCoordinateAxis(coordinateAxis);
    }

    public void setCoordinateAxis(CoordinateAxisModel coordinateAxis) {
        if (this.coordinateAxis != null) {
            this.coordinateAxis.removeCoordinateListener(this.coordinateAxisListener);
        }
        this.coordinateAxis = coordinateAxis;
        if (this.coordinateAxis != null) {
            this.coordinateAxis.addCoordinateListener(this.coordinateAxisListener);
        }
        this.repaint();
    }

    public YNumberCoordinateAxisGuide(Type type) {
        this.type = type;
    }

    public CoordinateAxisModel getCoordinateAxisModel() {
        return this.coordinateAxis;
    }

    public void setPanel(AxisPlotPanel panel) {
        this.panel = panel;
    }

    public double computeSpace(IGraphics g2, Rectangle dataArea) {
        AxisSpace space = new AxisSpace();
        this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Left, space);
        return space.getLeft();
    }

    public void setFormat(CPFormat format) {
        this.format = format;
        if (this.axis != null) {
            this.axis.setFormatOverride(this.format);
        }
        this.repaint();
    }

    public void drawGrid(IGraphics g2, Dimension d) {
        double max;
        double min;
        if (this.coordinateAxis != null && (min = this.coordinateAxis.getWorldMin()) <= (max = this.coordinateAxis.getWorldMax())) {
            Rectangle2D.Float dataArea = new Rectangle2D.Float(0.0f, 0.0f, d.width, d.height);
            this.getAxis().setRange(min, max);
            List ticks = this.getAxis().refreshTicks(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom);
            for (Object tick : ticks) {
                NumberTick t = (NumberTick)tick;
                int y = this.coordinateAxis.worldToScreen(t.getValue());
                g2.drawLine(0, y, d.width, y);
            }
        }
    }

    public void paintComponent(IGraphics g2) {
        double max;
        double min;
        Dimension d = this.getSize();
        if (this.coordinateAxis != null && (min = Math.min(this.coordinateAxis.getWorldMin(), this.coordinateAxis.getWorldMax())) < (max = Math.max(this.coordinateAxis.getWorldMin(), this.coordinateAxis.getWorldMax()))) {
            Rectangle2D.Float dataArea = new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
            this.getAxis().setRange(min, max);
            List ticks = this.getAxis().refreshTicks(g2, (Rectangle2D)dataArea, RectangleEdge.Left);
            for (Object tick : ticks) {
                NumberTick t = (NumberTick)tick;
                int y = this.coordinateAxis.worldToScreen(t.getValue());
                g2.setColor(this.gridLinesColor);
                switch (this.type) {
                    case Right: {
                        g2.drawLine(0, y, 5, y);
                        break;
                    }
                    case Left: {
                        g2.drawLine(d.width - 5, y, d.width, y);
                    }
                }
                g2.setColor(this.labelColor);
                String text = t.getText();
                CPFontMetrics fontMetrics = g2.getFontMetrics();
                float width = g2.getStringWidth(text);
                switch (this.type) {
                    case Right: {
                        g2.drawString(text, 7.0f, (float)(y + (fontMetrics.getAscent() >> 1)));
                        break;
                    }
                    case Left: {
                        g2.drawString(text, (float)d.width - width - 7.0f, (float)(y + (fontMetrics.getAscent() >> 1)));
                    }
                }
            }
        }
        if (this.drawFrame) {
            g2.setColor(this.frameColor);
            g2.drawRectange(0, 0, d.width - 1, d.height - 1);
        }
    }

    private ValueAxis getAxis() {
        if (this.axis == null) {
            this.axis = new NumberAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance());
            this.axis.setTickLabelFont(SwingFactory.getInstance().createFont("Tahoma", 0, 10));
            if (this.format != null) {
                this.axis.setFormatOverride(this.format);
            }
        }
        return this.axis;
    }

    public void setAxis(ValueAxis axis) {
        this.axis = axis;
        this.repaint();
    }

    public void setGridLinesColor(CPColor gridLinesColor) {
        this.gridLinesColor = gridLinesColor;
        this.repaint();
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
        this.repaint();
    }

    public static enum Type {
        Left,
        Right;

    }
}

