/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.action;

import com.macrofocus.util.interpolation.Interpolator;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public final class SmoothMacroZoomAction
extends AbstractAction {
    private final MBoundedRangeModel boundedRangeModel;
    private final long zoomAnimationDuration = 1000L;
    private InterpolatorThread interpolatorThread = null;
    private final Object mutex = new Object();
    private double lowerValue;
    private double upperValue;

    public SmoothMacroZoomAction(MBoundedRangeModel boundedRangeModel) {
        this.boundedRangeModel = boundedRangeModel;
    }

    public final void setValues(double lowerValue, double upperValue) {
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.doSmoothZoom(this.lowerValue, this.upperValue);
    }

    private void doSmoothZoom(final double newLowerValue, final double newUpperValue) {
        if (this.interpolatorThread != null && this.interpolatorThread.isAlive()) {
            this.interpolatorThread.cancel();
            try {
                this.interpolatorThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        final double currentLowerValue = this.boundedRangeModel.getValue();
        final double currentUpperValue = currentLowerValue + this.boundedRangeModel.getExtent();
        this.interpolatorThread = new InterpolatorThread(){
            private boolean stopped = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Interpolator interpolator = new Interpolator(0.0, 1.0, 1000L);
                do {
                    double factor = interpolator.getSmoothValue();
                    Object object = SmoothMacroZoomAction.this.mutex;
                    synchronized (object) {
                        double lower_value = currentLowerValue + factor * (newLowerValue - currentLowerValue);
                        double upper_value = currentUpperValue + factor * (newUpperValue - currentUpperValue);
                        SmoothMacroZoomAction.this.setRange(lower_value, upper_value);
                    }
                } while (!interpolator.finished() && !this.stopped);
                SmoothMacroZoomAction.this.setRange(newLowerValue, newUpperValue);
            }

            @Override
            public void cancel() {
                this.stopped = true;
            }
        };
        this.interpolatorThread.setPriority(1);
        this.interpolatorThread.start();
    }

    private void setRange(final double newLowerValue, final double newUpperValue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SmoothMacroZoomAction.this.boundedRangeModel.setValue((Object)this, newLowerValue, newUpperValue - newLowerValue);
            }
        });
    }

    public static abstract class InterpolatorThread
    extends Thread {
        public abstract void cancel();
    }
}

