/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.adapter;

import com.macrofocus.util.range.MBoundedRangeEvent;
import com.macrofocus.util.range.MBoundedRangeListener;
import com.macrofocus.util.range.MBoundedRangeModel;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MBoundedRangeAdapter
implements BoundedRangeModel {
    private final MBoundedRangeModel boundedRangeModel;
    private final EventListenerList listenerList;
    private ChangeEvent changeEvent = null;
    private boolean isAdjusting = false;
    private int adjustingValue;
    private static boolean continuousUpdate = true;

    public MBoundedRangeAdapter(MBoundedRangeModel boundedRangeModel) {
        this.boundedRangeModel = boundedRangeModel;
        this.listenerList = new EventListenerList();
        boundedRangeModel.addBoundedRangeListener(new MBoundedRangeListener(){

            public void boundedRangeChanged(MBoundedRangeEvent event) {
                MBoundedRangeAdapter.this.fireStateChanged();
            }
        });
    }

    @Override
    public int getMinimum() {
        return (int)(this.boundedRangeModel.getMinimum() * this.getMultiplier());
    }

    @Override
    public void setMinimum(int minimum) {
        this.boundedRangeModel.setMinimum((Object)this, (double)minimum / this.getMultiplier());
    }

    @Override
    public int getMaximum() {
        return (int)(this.boundedRangeModel.getMaximum() * this.getMultiplier());
    }

    @Override
    public void setMaximum(int maximum) {
        this.boundedRangeModel.setMaximum((Object)this, (double)maximum / this.getMultiplier());
    }

    @Override
    public int getValue() {
        return (int)(this.boundedRangeModel.getValue() * this.getMultiplier());
    }

    @Override
    public void setValue(int value) {
        this.adjustingValue = value;
        if (!this.isAdjusting || continuousUpdate) {
            double newValue = (double)value / this.getMultiplier();
            if (newValue < this.boundedRangeModel.getMinimum()) {
                newValue = this.boundedRangeModel.getMinimum();
            }
            if (newValue > this.boundedRangeModel.getMaximum()) {
                newValue = this.boundedRangeModel.getMaximum();
            }
            this.boundedRangeModel.setValue((Object)this, newValue);
        }
    }

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {
        if (this.isAdjusting != isAdjusting) {
            this.isAdjusting = isAdjusting;
            if (!isAdjusting) {
                this.setValue(this.adjustingValue);
            }
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public int getExtent() {
        return (int)(this.boundedRangeModel.getExtent() * this.getMultiplier());
    }

    @Override
    public void setExtent(int extent) {
        this.boundedRangeModel.setValue((Object)this, (double)extent / this.getMultiplier());
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.setValue(value);
        this.setExtent(extent);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValueIsAdjusting(adjusting);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public static void setContinuousUpdate(boolean value) {
        continuousUpdate = value;
    }

    public static boolean isContinuousUpdate() {
        return continuousUpdate;
    }

    private double getMultiplier() {
        return 1000.0 / (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum());
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.boundedRangeModel + "]";
    }
}

