/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.single;

import com.macrofocus.slider.single.SingleSliderEvent;
import com.macrofocus.slider.single.SingleSliderListener;
import com.macrofocus.slider.single.SingleSliderModel;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.OptimizedCoordinateAxisModel;
import com.macrofocus.util.swing.mouse.MMouseAdapter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class MSingleSlider
extends JComponent {
    private final SingleSliderModel model;
    private CoordinateAxisModel coordinateAxis;
    private Icon cursorIcon;
    private double alignment;
    private boolean keepCursorVisible = true;

    public MSingleSlider(final SingleSliderModel model, Icon cursorIcon, double alignment) {
        this.model = model;
        this.cursorIcon = cursorIcon;
        this.alignment = alignment;
        model.addSliderListener(new SingleSliderListener(){

            @Override
            public void sliderChanged(SingleSliderEvent e) {
                MSingleSlider.this.coordinateAxis.setWorld(model.getMinimum(), model.getMaximum());
                MSingleSlider.this.repaint();
            }
        });
        this.coordinateAxis = new OptimizedCoordinateAxisModel(model.getMinimum(), model.getMaximum());
        this.coordinateAxis.setDeviceCoordinatesInverted(true);
        MMouseAdapter mouseListener = new MMouseAdapter(){
            private MouseEvent last;
            private boolean cursorSelected;

            @Override
            public void mouseReleased(MouseEvent e) {
                this.last = null;
                this.cursorSelected = false;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.last = e;
                this.cursorSelected = MSingleSlider.this.getCursorBounds().contains(e.getPoint());
                if (!this.cursorSelected) {
                    double y = MSingleSlider.this.coordinateAxis.screenToWorld(e.getY());
                    model.setValue(y);
                    this.cursorSelected = true;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.cursorSelected) {
                    int diff = e.getY() - this.last.getY();
                    int currentY = MSingleSlider.this.coordinateAxis.worldToScreen(model.getValue());
                    int newY = currentY + diff;
                    double y = MSingleSlider.this.coordinateAxis.screenToWorld(newY);
                    model.setValue(y);
                    this.last = e;
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.coordinateAxis.setScreenSize(this.getSize().height);
        int x = (int)(this.alignment * (double)(this.getSize().width - this.cursorIcon.getIconWidth()));
        int y = this.coordinateAxis.worldToScreen(this.model.getValue());
        int halfHeight = this.cursorIcon.getIconHeight() / 2;
        if (this.keepCursorVisible) {
            y = Math.max(0, y);
            y = Math.min(this.getSize().height, y);
        }
        this.cursorIcon.paintIcon(this, g, x, y - halfHeight);
    }

    private Rectangle getCursorBounds() {
        int x = (int)(this.alignment * (double)(this.getSize().width - this.cursorIcon.getIconWidth()));
        int y = this.coordinateAxis.worldToScreen(this.model.getValue()) - this.cursorIcon.getIconHeight() / 2;
        return new Rectangle(x, y, this.cursorIcon.getIconWidth(), this.cursorIcon.getIconHeight());
    }

    private Point getCursorLocation() {
        int x = (int)(this.alignment * (double)(this.getSize().width - this.cursorIcon.getIconWidth()));
        int y = this.coordinateAxis.worldToScreen(this.model.getValue());
        return new Point(x, y);
    }
}

