/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.coordinator;

import com.macrofocus.util.range.MBoundedRangeEvent;
import com.macrofocus.util.range.MBoundedRangeListener;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class AspectRangesCoordinator {
    private Double minX;
    private Double maxX;
    private Double minY;
    private Double maxY;
    private Component component;
    private final MBoundedRangeModel xRange;
    private final MBoundedRangeModel yRange;
    final MBoundedRangeListener xRangeListener = new MBoundedRangeListener(){

        public void boundedRangeChanged(MBoundedRangeEvent event) {
            if (event.getSource() != AspectRangesCoordinator.this.getSelf() && event.getWhat() == MBoundedRangeEvent.What.MinMax) {
                AspectRangesCoordinator.this.minX = event.getModel().getMinimum();
                AspectRangesCoordinator.this.maxX = event.getModel().getMaximum();
            }
        }
    };
    final MBoundedRangeListener yRangeListener = new MBoundedRangeListener(){

        public void boundedRangeChanged(MBoundedRangeEvent event) {
            if (event.getSource() != AspectRangesCoordinator.this.getSelf() && event.getWhat() == MBoundedRangeEvent.What.MinMax) {
                AspectRangesCoordinator.this.minY = event.getModel().getMinimum();
                AspectRangesCoordinator.this.maxY = event.getModel().getMaximum();
            }
        }
    };

    public AspectRangesCoordinator(final MBoundedRangeModel xRange, final MBoundedRangeModel yRange, Component component) {
        this.component = component;
        this.xRange = xRange;
        this.yRange = yRange;
        xRange.addWeakBoundedRangeListener(this.xRangeListener);
        yRange.addWeakBoundedRangeListener(this.yRangeListener);
        component.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                AspectRangesCoordinator.this.adjust(xRange, yRange);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void adjust(MBoundedRangeModel xRange, MBoundedRangeModel yRange) {
        double shareY;
        double shareX;
        double share;
        if (this.maxX != null && this.minX != null && this.maxY != null && this.minY != null && !Double.isInfinite(share = Math.max(shareX = (this.maxX - this.minX) / (double)this.getComponent().getWidth(), shareY = (this.maxY - this.minY) / (double)this.getComponent().getHeight()))) {
            this.adjust(this.component.getWidth(), share, xRange, this.minX, this.maxX);
            this.adjust(this.component.getHeight(), share, yRange, this.minY, this.maxY);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    private void adjust(int size, double share, MBoundedRangeModel range, double min, double max) {
        double desiredRange = share * (double)size;
        double diffY = max - min - desiredRange;
        double newMin = min + diffY / 2.0;
        double newMax = max - diffY / 2.0;
        double newRange = newMax - newMin;
        double valueP = (range.getValue() - range.getMinimum()) / (range.getMaximum() - range.getMinimum());
        double extentP = range.getExtent() / (range.getMaximum() - range.getMinimum());
        range.setMinMax(this.getSelf(), newMin, newMax);
        range.setValue(this.getSelf(), valueP * newRange + newMin, extentP * newRange);
    }

    private Object getSelf() {
        return this;
    }
}

