/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.coordinate;

import com.macrofocus.soom.lens.coordinate.AbstractCoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;

public class ViewportCoordinateAxisModel
extends AbstractCoordinateAxisModel {
    private int screenSize;
    private double viewportMin;
    private double viewportMax;
    private double viewportRange;
    private double worldMin;
    private double worldMax;
    private double worldRange;

    protected ViewportCoordinateAxisModel(int screenSize, double viewportMin, double viewportMax, double viewportRange, double worldMin, double worldMax, double worldRange, ZoomStrategy zoomStrategy, boolean invertDeviceCoordinates, boolean invertWorldCoordinates) {
        super(zoomStrategy, invertDeviceCoordinates, invertWorldCoordinates);
        this.screenSize = screenSize;
        this.viewportMin = viewportMin;
        this.viewportMax = viewportMax;
        this.viewportRange = viewportRange;
        this.worldMin = worldMin;
        this.worldMax = worldMax;
        this.worldRange = worldRange;
    }

    public ViewportCoordinateAxisModel(int screenSize, double worldMin, double worldMax) {
        this.screenSize = screenSize;
        this.worldMax = worldMax;
        this.worldMin = worldMin;
        this.worldRange = worldMax - worldMin;
        this.viewportMin = 0.0;
        this.viewportMax = 1.0;
        this.viewportRange = 1.0;
    }

    public ViewportCoordinateAxisModel(double worldMin, double worldMax) {
        this(0, worldMin, worldMax);
    }

    @Override
    public int getScreenSize() {
        return this.screenSize;
    }

    @Override
    public void setScreenSize(int size) {
        if (this.screenSize != size) {
            this.screenSize = size;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Screen));
        }
    }

    @Override
    public void setWorld(double worldMinX, double worldMaxX) {
        if (this.worldMax != worldMaxX || this.worldMin != worldMinX) {
            this.worldMin = worldMinX;
            this.worldMax = worldMaxX;
            this.worldRange = worldMaxX - this.worldMin;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public void setWorldMax(double worldMaxX) {
        if (this.worldMax != worldMaxX) {
            this.worldMax = worldMaxX;
            this.worldRange = worldMaxX - this.worldMin;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public void setWorldMin(double worldMinX) {
        if (this.worldMin != worldMinX) {
            this.worldMin = worldMinX;
            this.worldRange = this.worldMax - worldMinX;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public void setViewport(double min, double max) {
        if (this.viewportMax != max || this.viewportMin != min) {
            this.viewportMin = min;
            this.viewportMax = max;
            this.viewportRange = this.getViewportMax() - this.getViewportMin();
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Viewport));
        }
    }

    @Override
    public void setViewportMax(double viewportMaxX) {
        if (this.viewportMax != viewportMaxX) {
            this.viewportMax = viewportMaxX;
            this.viewportRange = this.getViewportMax() - this.getViewportMin();
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Viewport));
        }
    }

    @Override
    public void setViewportMin(double viewportMinX) {
        if (this.getViewportMin() != viewportMinX) {
            this.viewportMin = viewportMinX;
            this.viewportRange = this.getViewportMax() - this.getViewportMin();
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Viewport));
        }
    }

    @Override
    public double getWorldMin() {
        return this.worldMin;
    }

    @Override
    public double getWorldMax() {
        return this.worldMax;
    }

    @Override
    public double getWorldRange() {
        return this.worldRange;
    }

    @Override
    public double getViewportRange() {
        return this.viewportRange;
    }

    @Override
    public double getViewportMin() {
        return this.viewportMin;
    }

    @Override
    public double getViewportMax() {
        return this.viewportMax;
    }

    @Override
    public ViewportCoordinateAxisModel copy() {
        return new ViewportCoordinateAxisModel(this.screenSize, this.viewportMin, this.viewportMax, this.viewportRange, this.worldMin, this.worldMax, this.worldRange, this.getZoomStrategy(), this.getDeviceCoordinatesInverted(), this.getWorldCoordinatesInverted());
    }
}

