/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.zoom;

import com.macrofocus.soom.lens.zoom.ZoomEvent;
import com.macrofocus.soom.lens.zoom.ZoomListener;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import java.util.Vector;

public class CartesianFisheyeZoom
implements ZoomStrategy {
    private double focusPositionNormalized;
    private double focusSizeNormalized;
    private double zoomFactor;
    private final Vector zoomListeners;

    public CartesianFisheyeZoom() {
        this(0.5, 0.0, 1.0);
    }

    public CartesianFisheyeZoom(double focusPositionWorld, double focusSizeWorld, double zoomFactor) {
        this.focusPositionNormalized = focusPositionWorld;
        this.focusSizeNormalized = focusSizeWorld;
        this.zoomFactor = zoomFactor;
        this.zoomListeners = new Vector();
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = this.focusSizeNormalized * zoomFactor > 1.0 ? 1.0 / this.focusSizeNormalized : zoomFactor;
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    private void setFocusPositionNormalized(double focusPositionNormalized) {
        this.focusPositionNormalized = focusPositionNormalized - this.focusSizeNormalized / 2.0 < 0.0 ? this.focusSizeNormalized / 2.0 : (focusPositionNormalized + this.focusSizeNormalized / 2.0 > 1.0 ? 1.0 - this.focusSizeNormalized / 2.0 : focusPositionNormalized);
    }

    private void setFocusSizeNormalized(double focusSizeNormalized) {
        this.focusSizeNormalized = focusSizeNormalized;
        if (this.focusPositionNormalized - focusSizeNormalized / 2.0 < 0.0) {
            this.focusPositionNormalized = focusSizeNormalized / 2.0;
        } else if (this.focusPositionNormalized + focusSizeNormalized / 2.0 > 1.0) {
            this.focusPositionNormalized = 1.0 - focusSizeNormalized / 2.0;
        }
    }

    public void setLensNormalized(double position, double size) {
        this.focusPositionNormalized = position;
        this.focusSizeNormalized = size;
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setZoomWindow(Object source, double x1, double x2) {
        double size = (x2 - x1) / this.zoomFactor;
        double focus = x1 * (1.0 - size) / (1.0 - size * this.zoomFactor) + size / 2.0;
        this.setFocusSizeNormalized(size);
        this.setFocusPositionNormalized(focus);
        this.fireZoomChanged(new ZoomEvent(source, this));
    }

    @Override
    public double normalizedToZoomed(double x) {
        if (this.focusSizeNormalized <= 0.0) {
            return x;
        }
        double[] boundaries = CartesianFisheyeZoom.getWindowBoundaries(this.focusPositionNormalized, this.focusSizeNormalized, this.zoomFactor);
        return this.focalTransformation(x, false, boundaries[0], boundaries[1], boundaries[2], boundaries[3]);
    }

    @Override
    public double zoomedToNormalized(double x) {
        if (this.focusSizeNormalized <= 0.0) {
            return x;
        }
        double[] boundaries = CartesianFisheyeZoom.getWindowBoundaries(this.focusPositionNormalized, this.focusSizeNormalized, this.zoomFactor);
        return this.focalTransformation(x, true, boundaries[2], boundaries[3], boundaries[0], boundaries[1]);
    }

    private double focalTransformation(double value_raw, boolean back_transformation, double window_low_raw, double window_high_raw, double window_low_trans, double window_high_trans) {
        double exponent = back_transformation ? 1.0 / this.zoomFactor : this.zoomFactor;
        double value_trans = value_raw < window_low_raw ? Math.pow(value_raw / window_low_raw, exponent) * window_low_trans : (value_raw > window_high_raw ? (1.0 - Math.pow(1.0 - (value_raw - window_high_raw) / (1.0 - window_high_raw), exponent)) * (1.0 - window_high_trans) + window_high_trans : (value_raw - window_low_raw) / (window_high_raw - window_low_raw) * (window_high_trans - window_low_trans) + window_low_trans);
        return value_trans;
    }

    private static double[] getWindowBoundaries(double focus_location, double focus_width, double zoom_factor) {
        double low_width_zoom;
        double[] boundaries = new double[4];
        double x1w = focus_location - focus_width / 2.0;
        double x2w = focus_location + focus_width / 2.0;
        double low_width_percentage_world = x1w / (1.0 - focus_width);
        double focus_width_zoom = focus_width * zoom_factor;
        double x1z = low_width_zoom = low_width_percentage_world * (1.0 - focus_width_zoom);
        double x2z = low_width_zoom + focus_width_zoom;
        boundaries[0] = x1w;
        boundaries[1] = x2w;
        boundaries[2] = x1z;
        boundaries[3] = x2z;
        return boundaries;
    }

    public double getFocusPositionNormalized() {
        return this.focusPositionNormalized;
    }

    public double getFocusSizeNormalized() {
        return this.focusSizeNormalized;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void addZoomListener(ZoomListener listener) {
        this.zoomListeners.addElement(listener);
    }

    @Override
    public void removeZoomListener(ZoomListener listener) {
        this.zoomListeners.removeElement(listener);
    }

    private void fireZoomChanged(ZoomEvent event) {
        for (int i = 0; i < this.zoomListeners.size(); ++i) {
            ZoomListener zoomListener = (ZoomListener)this.zoomListeners.elementAt(i);
            zoomListener.zoomChanged(event);
        }
    }

    public String toString() {
        return "CartesianFisheyeZoom (position world, size world, zoomfactor): " + this.focusPositionNormalized + ", " + this.focusSizeNormalized + ", " + this.zoomFactor;
    }
}

