/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.time;

import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisListener;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.zoom.BifocalLensZoom;
import com.macrofocus.soom.lens.zoom.ZoomEvent;
import com.macrofocus.soom.lens.zoom.ZoomListener;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import com.macrofocus.soom.time.GridModel;

public class LensGridModel {
    private GridModel gridLeftOutside;
    private GridModel gridInside;
    private GridModel gridRightOutside;
    private int lowerLensBoundaryScreen;
    private int upperLensBoundaryScreen;
    private CoordinateAxisModel coordinateAxisModel;

    public LensGridModel(CoordinateAxisModel coordinateAxisModel) {
        this.coordinateAxisModel = coordinateAxisModel;
        final ZoomStrategy zoomStrategy = coordinateAxisModel.getZoomStrategy();
        this.coordinateAxisModel.addCoordinateListener(new CoordinateAxisListener(){

            @Override
            public void rangeChanged(CoordinateAxisEvent e) {
                LensGridModel.this.updateGrids(zoomStrategy);
            }
        });
        if (zoomStrategy != null) {
            zoomStrategy.addZoomListener(new ZoomListener(){

                @Override
                public void zoomChanged(ZoomEvent e) {
                    LensGridModel.this.updateGrids(zoomStrategy);
                }
            });
        }
        this.gridLeftOutside = new GridModel(coordinateAxisModel);
        this.gridInside = new GridModel(coordinateAxisModel);
        this.gridRightOutside = new GridModel(coordinateAxisModel);
    }

    private void updateGrids(ZoomStrategy zoomStrategy) {
        if (zoomStrategy instanceof BifocalLensZoom) {
            BifocalLensZoom bifocalLens = (BifocalLensZoom)zoomStrategy;
            if (bifocalLens.isLensActive()) {
                double[] lens_boundaries = bifocalLens.getLensBoundariesZoomed();
                this.lowerLensBoundaryScreen = this.coordinateAxisModel.viewportToScreen(lens_boundaries[0]);
                this.upperLensBoundaryScreen = this.coordinateAxisModel.viewportToScreen(lens_boundaries[1]);
                double boundary_low_normalized = bifocalLens.getFocusPositionNormalized() - bifocalLens.getFocusSizeNormalized() / 2.0;
                double boundary_high_normalized = bifocalLens.getFocusPositionNormalized() + bifocalLens.getFocusSizeNormalized() / 2.0;
                long lens_boundary_low_world = (long)this.coordinateAxisModel.normalizedToWorld(boundary_low_normalized);
                long lens_boundary_high_world = (long)this.coordinateAxisModel.normalizedToWorld(boundary_high_normalized);
                long window_low_date = (long)this.coordinateAxisModel.getWorldMin();
                long window_high_date = lens_boundary_low_world;
                this.gridLeftOutside.setWindow(window_low_date, window_high_date);
                window_low_date = lens_boundary_low_world;
                window_high_date = lens_boundary_high_world;
                this.gridInside.setWindow(window_low_date, window_high_date);
                window_low_date = lens_boundary_high_world;
                window_high_date = (long)this.coordinateAxisModel.getWorldMax();
                this.gridRightOutside.setWindow(window_low_date, window_high_date);
            } else {
                this.lowerLensBoundaryScreen = -1;
                this.upperLensBoundaryScreen = -1;
                this.gridInside.setWindow((long)this.coordinateAxisModel.getWorldMin(), (long)this.coordinateAxisModel.getWorldMax());
            }
        } else {
            this.gridInside.setWindow((long)this.coordinateAxisModel.getWorldMin(), (long)this.coordinateAxisModel.getWorldMax());
        }
    }

    public GridModel getGridLeftOutside() {
        return this.gridLeftOutside;
    }

    public GridModel getGridInside() {
        return this.gridInside;
    }

    public GridModel getGridRightOutside() {
        return this.gridRightOutside;
    }

    public int getLowerLensBoundaryScreen() {
        return this.lowerLensBoundaryScreen;
    }

    public int getUpperLensBoundaryScreen() {
        return this.upperLensBoundaryScreen;
    }
}

