/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.awt;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class AutomouseTimer
extends Thread {
    private final Component component;
    private final Rectangle selectedRectangle;
    private final MouseListener mouseListener;
    private final MouseEvent mouseEvent;
    private final int initialDelay;
    private final int delay;
    private boolean stopped;

    public AutomouseTimer(Component component, Rectangle selectedRectangle, MouseListener mouseListener, MouseEvent mouseEvent, int initialDelay, int delay) {
        this.component = component;
        this.selectedRectangle = selectedRectangle;
        this.mouseListener = mouseListener;
        this.mouseEvent = mouseEvent;
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.stopped = false;
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this) {
            try {
                AutomouseTimer.sleep(this.initialDelay);
                this.postMouseEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!this.stopped) {
                try {
                    AutomouseTimer.sleep(this.delay);
                    this.postMouseEvent();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void postMouseEvent() {
        if (!this.stopped) {
            this.mouseListener.mousePressed(this.mouseEvent);
        }
    }

    public void doStop() {
        this.stopped = true;
    }
}

