/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.awt;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.image.ImageHelper;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;

public final class ImageModel {
    private Image image = null;

    public ImageModel(Image image) {
        this.image = image;
    }

    public ImageModel(URL url) {
        BufferedInputStream in = null;
        try {
            InputStream stream = url.openStream();
            in = new BufferedInputStream(stream);
        }
        catch (Exception e) {
            System.err.println("Error opening URL " + url);
            Logging.getInstance().process((Throwable)e);
            return;
        }
        try {
            byte[] buffer = new byte[((InputStream)in).available()];
            ((InputStream)in).read(buffer);
            this.image = Toolkit.getDefaultToolkit().createImage(buffer);
        }
        catch (Exception e) {
            System.err.println("Unable to create image " + url);
            Logging.getInstance().process((Throwable)e);
        }
    }

    public ImageModel(String fileName) {
        this.image = ImageHelper.loadGif(this.getClass(), (String)fileName);
    }

    public Image getImage() {
        return this.image;
    }
}

