/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.awt;

import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class LightweightBubble
extends JComponent {
    private AlphaComposite myAlpha = AlphaComposite.getInstance(3, 0.5f);
    private final RenderingHintsModel renderingHintsModel;
    private String text;

    public LightweightBubble(String text, RenderingHintsModel renderingHintsModel) {
        this.text = text;
        this.setFocusable(false);
        this.renderingHintsModel = renderingHintsModel;
    }

    public void setAlpha(AlphaComposite alpha) {
        this.myAlpha = alpha;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Dimension d = this.text != null ? new Dimension(fm.stringWidth(this.text) + 2, fm.getHeight()) : new Dimension(0, fm.getHeight());
        return d;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.renderingHintsModel.getRenderingHints());
        this.draw(g2, true);
    }

    @Override
    protected void printComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.draw(g2, false);
    }

    public void draw(Graphics2D g2, boolean alphaComposition) {
        FontMetrics fm = g2.getFontMetrics();
        Composite oldAC = g2.getComposite();
        if (alphaComposition) {
            g2.setComposite(this.myAlpha);
        }
        g2.setColor(this.getBackground());
        int x = 1;
        int y = fm.getAscent();
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (alphaComposition) {
            g2.setComposite(oldAC);
        }
        g2.setColor(this.getForeground());
        g2.drawString(this.text, x, y);
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFont(UIManager.getFont("Tree.font"));
    }
}

