/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.data.ColumnMajorDataModel;
import com.macrofocus.data.DataHelper;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.column.SimpleColumnModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.SimpleMatrixModel;
import com.macrofocus.data.matrix.stat.MinMaxMatrixModel;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.util.geometry.DelaunayPanel;
import com.macrofocus.util.geometry.ExtendedDelaunay;
import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.SegmentModel;
import com.macrofocus.util.geometry.VoronoiPointModel;
import com.macrofocus.util.geometry.VoronoiVisitor;
import com.macrofocus.util.swing.action.PrintComponentAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class ConvertToVoronoi {
    public static void main(String[] args) {
        DataModel dataModel = DataHelper.loadTxt((String)"d:/java/data/com/macrofocus/application/fund/scope/feritrust/spring.txt");
        System.err.println(dataModel.getRowCount());
        SimpleMatrixModel matrixModel = new SimpleMatrixModel(dataModel);
        MinMaxMatrixModel minMaxMatrixModel = new MinMaxMatrixModel((MatrixModel)matrixModel);
        long start = System.currentTimeMillis();
        ExtendedDelaunay delaunay = new ExtendedDelaunay();
        for (int row = 0; row < matrixModel.getRowCount(); ++row) {
            if (!matrixModel.isAvailable(row, 0) || !matrixModel.isAvailable(row, 1)) continue;
            PointModel p = new PointModel(matrixModel.getDouble(row, 0), matrixModel.getDouble(row, 1));
            delaunay.insertPoint(p);
        }
        delaunay.startTriangle.visitDual(new VoronoiVisitor(){

            @Override
            public void visiting(PointModel p1, PointModel p2, SegmentModel segmentModel) {
                p1.addVoronoi(segmentModel);
                p2.addVoronoi(segmentModel);
            }
        });
        System.err.println("Voronoi: " + (double)(System.currentTimeMillis() - start) / 1000.0);
        Object[] voronoiPointModels = new VoronoiPointModel[matrixModel.getRowCount()];
        for (int row = 0; row < matrixModel.getRowCount(); ++row) {
            if (!matrixModel.isAvailable(row, 0) || !matrixModel.isAvailable(row, 1)) continue;
            PointModel pointModel = new PointModel(matrixModel.getDouble(row, 0), matrixModel.getDouble(row, 1));
            double firstDist = Double.MAX_VALUE;
            int firstIndex = -1;
            PointModel firstPointModel = null;
            for (int i = 0; i < delaunay.canvas.getShapeCount(0); ++i) {
                double dist = pointModel.distance2((PointModel)delaunay.canvas.getShape(0, i));
                if (!(dist <= firstDist)) continue;
                firstDist = dist;
                firstIndex = i;
                firstPointModel = (PointModel)delaunay.canvas.getShape(0, i);
            }
            VoronoiPointModel voronoiPointModel = new VoronoiPointModel(firstPointModel);
            for (int j = 0; j < firstPointModel.getVoronoiCount(); ++j) {
                SegmentModel segmentModel = firstPointModel.getVoronoi(j);
                voronoiPointModel.addSegmentModel(segmentModel);
            }
            voronoiPointModel.pack();
            voronoiPointModels[row] = voronoiPointModel;
        }
        SimpleColumnModel columnModel = new SimpleColumnModel((Object)"Voronoi", VoronoiPointModel.class, voronoiPointModels);
        ColumnMajorDataModel columnMajorDataModel = new ColumnMajorDataModel();
        columnMajorDataModel.addColumnModel((ColumnModel)columnModel);
        for (int column = 0; column < dataModel.getColumnCount(); ++column) {
            columnMajorDataModel.addColumnModel(dataModel.getColumnModel(column));
        }
        DataHelper.saveTxt((DataModel)columnMajorDataModel, (String)"voronoi.txt");
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File", true);
        PrintComponentAction printAction = new PrintComponentAction(frame.getContentPane());
        file.add(printAction);
        mb.add(file);
        frame.setJMenuBar(mb);
        DelaunayPanel panel = new DelaunayPanel(minMaxMatrixModel, delaunay);
        frame.setSize(800, 600);
        frame.getContentPane().setBackground(Color.white);
        frame.getContentPane().setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        frame.getContentPane().add((Component)panel, new RelativeProportionalConstraint());
        frame.validate();
        frame.setVisible(true);
    }
}

