/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.data.DataHelper;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.SimpleMatrixModel;
import com.macrofocus.data.matrix.stat.MinMaxMatrixModel;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.util.geometry.DelaunayPanel;
import com.macrofocus.util.geometry.ExtendedDelaunay;
import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.SegmentModel;
import com.macrofocus.util.geometry.VoronoiVisitor;
import com.macrofocus.util.swing.action.PrintComponentAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class Test {
    public static void main(String[] args) {
        DataModel dataModel = DataHelper.loadTxt((String)"data/com/macrofocus/application/fund/scope/feritrust/spring.txt");
        System.err.println(dataModel.getRowCount());
        SimpleMatrixModel matrixModel = new SimpleMatrixModel(dataModel);
        MinMaxMatrixModel minMaxMatrixMode = new MinMaxMatrixModel((MatrixModel)matrixModel);
        long start = System.currentTimeMillis();
        ExtendedDelaunay delaunay = new ExtendedDelaunay();
        for (int row = 0; row < matrixModel.getRowCount(); ++row) {
            if (!matrixModel.isAvailable(row, 0) || !matrixModel.isAvailable(row, 1)) continue;
            PointModel p = new PointModel(matrixModel.getDouble(row, 0), matrixModel.getDouble(row, 1));
            delaunay.insertPoint(p);
        }
        delaunay.startTriangle.visitDual(new VoronoiVisitor(){

            @Override
            public void visiting(PointModel p1, PointModel p2, SegmentModel segmentModel) {
                p1.addVoronoi(segmentModel);
                p2.addVoronoi(segmentModel);
            }
        });
        System.err.println("Voronoi: " + (double)(System.currentTimeMillis() - start) / 1000.0);
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File", true);
        PrintComponentAction printAction = new PrintComponentAction(frame.getContentPane());
        file.add(printAction);
        mb.add(file);
        frame.setJMenuBar(mb);
        DelaunayPanel panel = new DelaunayPanel(minMaxMatrixMode, delaunay);
        frame.setSize(800, 600);
        frame.getContentPane().setBackground(Color.white);
        frame.getContentPane().setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        frame.getContentPane().add((Component)panel, new RelativeProportionalConstraint());
        frame.validate();
        frame.setVisible(true);
    }
}

