/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.geometry.CircleModel;
import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.RayModel;
import com.macrofocus.util.geometry.SegmentModel;
import com.macrofocus.util.geometry.SegmentVisitor;
import com.macrofocus.util.geometry.ShapeModel;
import com.macrofocus.util.geometry.TriangleVisitor;
import com.macrofocus.util.geometry.VoronoiVisitor;

public class TriangleModel
implements ShapeModel {
    private PointModel a;
    private PointModel b;
    private PointModel c;
    private TriangleModel abnext;
    private TriangleModel bcnext;
    private TriangleModel canext;
    private CircleModel circum;
    private boolean halfplane = false;
    private boolean visitflag;
    private static boolean visitValue = false;

    public TriangleModel(PointModel A, PointModel B, PointModel C) {
        this.setVisitflag(TriangleModel.isVisitValue());
        this.setPointA(A);
        int res = C.pointLineTest(A, B);
        if (res <= 1 || res == 3 || res == 4) {
            this.setPointB(B);
            this.setPointC(C);
        } else {
            this.setPointB(C);
            this.setPointC(A);
            System.err.println("Warning, TriangleModel(A,B,C) expects points in counterclockwise order.");
        }
        this.circumcircle();
    }

    public TriangleModel(PointModel A, PointModel B) {
        this.setVisitflag(TriangleModel.isVisitValue());
        this.setPointA(A);
        this.setPointB(B);
        this.setHalfplane(true);
    }

    public TriangleModel find(PointModel p) {
        if (p.pointLineTest(this.getA(), this.getB()) >= 2) {
            return this.getAbnext().findnext(p, this);
        }
        if (this.isHalfplane()) {
            return this;
        }
        if (p.pointLineTest(this.getB(), this.getC()) >= 2) {
            return this.getBcnext().findnext(p, this);
        }
        if (p.pointLineTest(this.getC(), this.getA()) >= 2) {
            return this.getCanext().findnext(p, this);
        }
        return this;
    }

    private TriangleModel findnext(PointModel p, TriangleModel v) {
        TriangleModel t2;
        TriangleModel t1;
        PointModel p3;
        PointModel p2;
        PointModel p1;
        if (this.isHalfplane()) {
            switch (p.pointLineTest(this.getA(), this.getB())) {
                case 0: 
                case 1: {
                    return this;
                }
                case 3: {
                    return this.getCanext().findnext(p, this);
                }
                case 4: {
                    return this.getBcnext().findnext(p, this);
                }
                case 2: {
                    try {
                        throw new RuntimeException("Should not happen: point not in halfplane.");
                    }
                    catch (RuntimeException e) {
                        Logging.getInstance().process((Throwable)e);
                        return this.getAbnext().findnext(p, this);
                    }
                }
            }
        }
        if (this.getAbnext() == v) {
            p1 = this.getB();
            p2 = this.getC();
            p3 = this.getA();
            t1 = this.getBcnext();
            t2 = this.getCanext();
        } else if (this.getBcnext() == v) {
            p1 = this.getC();
            p2 = this.getA();
            p3 = this.getB();
            t1 = this.getCanext();
            t2 = this.getAbnext();
        } else {
            p1 = this.getA();
            p2 = this.getB();
            p3 = this.getC();
            t1 = this.getAbnext();
            t2 = this.getBcnext();
        }
        if (p.pointLineTest(p1, p2) >= 2) {
            return t1.findnext(p, this);
        }
        if (p.pointLineTest(p2, p3) >= 2) {
            return t2.findnext(p, this);
        }
        return this;
    }

    public void switchneighbors(TriangleModel oldT, TriangleModel newT) {
        if (this.getAbnext() == oldT) {
            this.setNextTriangleAb(newT);
        } else if (this.getBcnext() == oldT) {
            this.setNextTriangleBc(newT);
        } else if (this.getCanext() == oldT) {
            this.setNextTriangleCa(newT);
        } else {
            throw new RuntimeException("Error, switchneighbors can't find old.");
        }
    }

    public TriangleModel neighbor(PointModel p) {
        if (this.getA() == p) {
            return this.getCanext();
        }
        if (this.getB() == p) {
            return this.getAbnext();
        }
        if (this.getC() == p) {
            return this.getBcnext();
        }
        throw new RuntimeException("Error, neighbors can't find p: " + p);
    }

    public CircleModel circumcircle() {
        double u = ((this.getA().x - this.getB().x) * (this.getA().x + this.getB().x) + (this.getA().y - this.getB().y) * (this.getA().y + this.getB().y)) / 2.0;
        double v = ((this.getB().x - this.getC().x) * (this.getB().x + this.getC().x) + (this.getB().y - this.getC().y) * (this.getB().y + this.getC().y)) / 2.0;
        double den = (this.getA().x - this.getB().x) * (this.getB().y - this.getC().y) - (this.getB().x - this.getC().x) * (this.getA().y - this.getB().y);
        if (den == 0.0) {
            this.setCircum(new CircleModel(this.getA(), Double.POSITIVE_INFINITY));
        } else {
            PointModel cen = new PointModel((u * (this.getB().y - this.getC().y) - v * (this.getA().y - this.getB().y)) / den, (v * (this.getA().x - this.getB().x) - u * (this.getB().x - this.getC().x)) / den);
            this.setCircum(new CircleModel(cen, cen.distance2(this.getA())));
        }
        return this.getCircum();
    }

    public boolean circumcircle_contains(PointModel p) {
        return this.getCircum().r > this.getCircum().c.distance2(p);
    }

    public void visit(TriangleVisitor visitor) {
        TriangleModel.setVisitValue(!TriangleModel.isVisitValue());
        this.visitMore(visitor);
    }

    private void visitMore(TriangleVisitor visitor) {
        this.setVisitflag(TriangleModel.isVisitValue());
        if (!this.isHalfplane()) {
            visitor.visiting(this);
        }
        if (this.getAbnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getAbnext().visitMore(visitor);
        }
        if (this.getBcnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getBcnext().visitMore(visitor);
        }
        if (this.getCanext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getCanext().visitMore(visitor);
        }
    }

    public void visitVoronoi(SegmentVisitor visitor) {
        TriangleModel.setVisitValue(!TriangleModel.isVisitValue());
        this.visitMoreVoronoi(visitor);
    }

    public void visitMoreVoronoi(SegmentVisitor visitor) {
        this.setVisitflag(TriangleModel.isVisitValue());
        TriangleModel t = this;
        TriangleModel ttn = null;
        TriangleModel tt = this;
        ttn = t.halfplane ? t.abnext : t.bcnext;
        int count = 0;
        do {
            SegmentModel dualEdge2;
            SegmentModel dualEdge;
            if (!((dualEdge = tt.getDualEdge(ttn)) instanceof RayModel)) {
                visitor.visiting(dualEdge);
            }
            if (!tt.halfplane && !((dualEdge2 = tt.getDualEdge(tt.abnext)) instanceof RayModel)) {
                visitor.visiting(dualEdge2);
            }
            tt = ttn;
            ttn = tt.bcnext;
        } while (tt != t && !tt.halfplane && ++count < 100);
        if (this.getAbnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getAbnext().visitVoronoi(visitor);
        }
        if (this.getBcnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getBcnext().visitVoronoi(visitor);
        }
        if (this.getCanext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getCanext().visitVoronoi(visitor);
        }
    }

    public void visitDual(SegmentVisitor visitor) {
        TriangleModel.setVisitValue(!TriangleModel.isVisitValue());
        this.visitMoreDual(visitor);
    }

    private void visitMoreDual(SegmentVisitor visitor) {
        this.setVisitflag(TriangleModel.isVisitValue());
        if (this.getAbnext().isVisitflag() != TriangleModel.isVisitValue()) {
            visitor.visiting(this.getDualEdge(this.getAbnext()));
        }
        if (!this.isHalfplane()) {
            if (this.getBcnext().isVisitflag() != TriangleModel.isVisitValue()) {
                visitor.visiting(this.getDualEdge(this.getBcnext()));
            }
            if (this.getCanext().isVisitflag() != TriangleModel.isVisitValue()) {
                visitor.visiting(this.getDualEdge(this.getCanext()));
            }
        }
        if (this.getAbnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getAbnext().visitMoreDual(visitor);
        }
        if (this.getBcnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getBcnext().visitMoreDual(visitor);
        }
        if (this.getCanext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getCanext().visitMoreDual(visitor);
        }
    }

    public void visitDual(VoronoiVisitor visitor) {
        TriangleModel.setVisitValue(!TriangleModel.isVisitValue());
        this.visitMoreDual(visitor);
    }

    private void visitMoreDual(VoronoiVisitor visitor) {
        this.setVisitflag(TriangleModel.isVisitValue());
        if (this.getAbnext().isVisitflag() != TriangleModel.isVisitValue()) {
            visitor.visiting(this.a, this.b, this.getDualEdge(this.getAbnext()));
        }
        if (!this.isHalfplane()) {
            if (this.getBcnext().isVisitflag() != TriangleModel.isVisitValue()) {
                visitor.visiting(this.b, this.c, this.getDualEdge(this.getBcnext()));
            }
            if (this.getCanext().isVisitflag() != TriangleModel.isVisitValue()) {
                visitor.visiting(this.c, this.a, this.getDualEdge(this.getCanext()));
            }
        }
        if (this.getAbnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getAbnext().visitMoreDual(visitor);
        }
        if (this.getBcnext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getBcnext().visitMoreDual(visitor);
        }
        if (this.getCanext().isVisitflag() != TriangleModel.isVisitValue()) {
            this.getCanext().visitMoreDual(visitor);
        }
    }

    public void visitHull(SegmentVisitor visitor) {
        TriangleModel tt = this;
        do {
            visitor.visiting(new SegmentModel(tt.getA(), tt.getB()));
        } while ((tt = tt.getCanext()) != this);
    }

    public SegmentModel getDualEdge(TriangleModel t) {
        if (t.isHalfplane()) {
            if (this.isHalfplane()) {
                System.out.println("Warning, no dual edge between two halfplanes.");
                System.out.println("" + this + t);
                return null;
            }
            return new RayModel(this.getCircum().c, new PointModel(this.getCircum().c.x - (t.getB().y - t.getA().y), this.getCircum().c.y + (t.getB().x - t.getA().x)));
        }
        if (this.isHalfplane()) {
            return new RayModel(t.getCircum().c, new PointModel(t.getCircum().c.x - (this.getB().y - this.getA().y), t.getCircum().c.y + (this.getB().x - this.getA().x)));
        }
        return new SegmentModel(this.getCircum().c, t.getCircum().c);
    }

    public String toString() {
        return this.getClass().getName() + "[a=" + this.getA() + ",b=" + this.getB() + "c=" + this.getC() + "]";
    }

    public PointModel getA() {
        return this.a;
    }

    public void setPointA(PointModel a) {
        this.a = a;
    }

    public PointModel getB() {
        return this.b;
    }

    public void setPointB(PointModel b) {
        this.b = b;
    }

    public PointModel getC() {
        return this.c;
    }

    public void setPointC(PointModel c) {
        this.c = c;
    }

    public TriangleModel getAbnext() {
        return this.abnext;
    }

    public void setNextTriangleAb(TriangleModel abnext) {
        this.abnext = abnext;
    }

    public TriangleModel getBcnext() {
        return this.bcnext;
    }

    public void setNextTriangleBc(TriangleModel bcnext) {
        this.bcnext = bcnext;
    }

    public TriangleModel getCanext() {
        return this.canext;
    }

    public void setNextTriangleCa(TriangleModel canext) {
        this.canext = canext;
    }

    public CircleModel getCircum() {
        return this.circum;
    }

    public void setCircum(CircleModel circum) {
        this.circum = circum;
    }

    public boolean isHalfplane() {
        return this.halfplane;
    }

    public void setHalfplane(boolean halfplane) {
        this.halfplane = halfplane;
    }

    public boolean isVisitflag() {
        return this.visitflag;
    }

    public void setVisitflag(boolean visitflag) {
        this.visitflag = visitflag;
    }

    public static boolean isVisitValue() {
        return visitValue;
    }

    public static void setVisitValue(boolean visitValue) {
        TriangleModel.visitValue = visitValue;
    }

    public TriangleModel() {
        this.setVisitflag(TriangleModel.isVisitValue());
    }
}

