/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.java2d;

import com.macrofocus.util.java2d.RenderingHintsEvent;
import com.macrofocus.util.java2d.RenderingHintsListener;
import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.RenderingHints;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleRenderingHintsModel
implements RenderingHintsModel {
    private final List<RenderingHintsListener> listeners;
    private RenderingHints renderingHints = new RenderingHints(new HashMap());

    public SimpleRenderingHintsModel() {
        this.listeners = new CopyOnWriteArrayList<RenderingHintsListener>();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object value) {
        this.renderingHints.put(key, value);
        this.notifyRenderingHintsChanged(new RenderingHintsEvent(this, this));
    }

    @Override
    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
        this.notifyRenderingHintsChanged(new RenderingHintsEvent(this, this));
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void addRenderingHintsListener(RenderingHintsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addWeakRenderingHintsListener(RenderingHintsListener listener) {
        this.listeners.add(new WeakRenderingHintsListener(listener));
    }

    @Override
    public void removeRenderingHintsListener(RenderingHintsListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyRenderingHintsChanged(RenderingHintsEvent event) {
        for (RenderingHintsListener listener : this.listeners) {
            listener.renderingHintsChanged(event);
        }
    }

    private class WeakRenderingHintsListener
    implements RenderingHintsListener {
        private final WeakReference<RenderingHintsListener> l_ref;

        public WeakRenderingHintsListener(RenderingHintsListener listener) {
            this.l_ref = new WeakReference<RenderingHintsListener>(listener);
        }

        @Override
        public void renderingHintsChanged(RenderingHintsEvent event) {
            RenderingHintsListener l = (RenderingHintsListener)this.l_ref.get();
            if (l != null) {
                l.renderingHintsChanged(event);
            } else {
                SimpleRenderingHintsModel.this.removeRenderingHintsListener(this);
            }
        }
    }
}

