/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.logging;

import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.layoutmanager.PreferredProportionalConstraint;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.util.date.DateHelper;
import com.macrofocus.util.logging.LogView;
import com.macrofocus.util.swing.MFileChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SimpleLogView
extends LogView {
    private JFrame frame;
    private JTextArea textArea;
    private JScrollBar scrollBar;
    private Date snoozeUntil;
    private boolean show;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SimpleLogView(final JFrame frame, boolean show) {
        this.frame = frame;
        this.show = show;
        this.snoozeUntil = new Date();
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setTabSize(4);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea, 22, 32);
        this.scrollBar = areaScrollPane.getVerticalScrollBar();
        JButton clearButton = new JButton("Clear");
        clearButton.setToolTipText("Clear debugging log.");
        clearButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLogView.this.textArea.setText("");
            }
        }, (Object)clearButton));
        JButton copyButton = new JButton("Copy");
        copyButton.setToolTipText("Copy debugging log to the clipboard.");
        copyButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection stsel = new StringSelection(SimpleLogView.this.textArea.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stsel, stsel);
            }
        }, (Object)copyButton));
        JButton saveButton = new JButton("Save");
        saveButton.setToolTipText("Save debugging log to a file.");
        saveButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MFileChooser fileChooser = new MFileChooser();
                fileChooser.setDialogTitle("Save debug log to which file?");
                int result = fileChooser.showSaveDialog(frame);
                File file = null;
                if (result == 0) {
                    file = fileChooser.getSelectedFile();
                    String filename = file.getAbsolutePath();
                    if (file.isDirectory()) {
                        JOptionPane.showMessageDialog(null, filename + " is not a file!", "Error", 0);
                        return;
                    }
                    if (file.exists() && !file.canWrite()) {
                        JOptionPane.showMessageDialog(null, filename + " is not a writable file!", "Error", 0);
                        return;
                    }
                    try {
                        FileWriter fileWriter = new FileWriter(file);
                        fileWriter.write(SimpleLogView.this.textArea.getText());
                        fileWriter.close();
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(null, "Error while writing debug log to file " + filename, "Error", 0);
                    }
                }
            }
        }, (Object)saveButton));
        JButton closeButton = new JButton("Close");
        closeButton.setToolTipText("Close debugging log window.");
        closeButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.hide();
            }
        }, (Object)closeButton));
        JButton snoozeButton = new JButton("Snooze");
        snoozeButton.setToolTipText("Snooze debugging log window for 2 minutes.");
        snoozeButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLogView.this.snoozeUntil = DateHelper.addMinutes((Date)new Date(), (int)2);
                frame.hide();
            }
        }, (Object)snoozeButton));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.hide();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new HorizontalProportionalLayoutManager());
        panel.add((Component)new JPanel(), new RelativeProportionalConstraint(4, 4, 4, 4));
        panel.add((Component)clearButton, new PreferredProportionalConstraint(4, 4, 4, 4));
        panel.add((Component)copyButton, new PreferredProportionalConstraint(4, 4, 4, 4));
        panel.add((Component)saveButton, new PreferredProportionalConstraint(4, 4, 4, 4));
        if (show) {
            panel.add((Component)snoozeButton, new PreferredProportionalConstraint(4, 4, 4, 4));
        }
        panel.add((Component)closeButton, new PreferredProportionalConstraint(4, 4, 4, 4));
        this.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        this.add(areaScrollPane, new RelativeProportionalConstraint());
        this.add(panel, new PreferredProportionalConstraint());
        this.validate();
    }

    public void addLine(String text) {
        this.textArea.append(text);
        this.scrollBar.setValue(this.scrollBar.getMaximum());
        if (this.show && !this.frame.isVisible() && new Date().after(this.snoozeUntil)) {
            this.frame.show();
        }
    }
}

