/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing;

import com.macrofocus.util.java2d.RenderingHintsEvent;
import com.macrofocus.util.java2d.RenderingHintsListener;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.swing.Translucent;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MPanel
extends JPanel
implements Translucent {
    private RenderingHintsModel renderingHintsModel;
    private float alpha = 1.0f;
    private boolean oldOpaque;
    private final RenderingHintsListener listener = new RenderingHintsListener(){

        @Override
        public void renderingHintsChanged(RenderingHintsEvent event) {
            MPanel.this.repaint();
        }
    };

    public MPanel() {
    }

    public MPanel(LayoutManager layout, RenderingHintsModel renderingHintsModel) {
        super(layout);
        this.renderingHintsModel = renderingHintsModel;
        if (renderingHintsModel != null) {
            renderingHintsModel.addWeakRenderingHintsListener(this.listener);
        }
    }

    public MPanel(RenderingHintsModel renderingHintsModel) {
        this.setRenderingHintsModel(renderingHintsModel);
    }

    public void setRenderingHintsModel(RenderingHintsModel renderingHintsModel) {
        if (this.renderingHintsModel != renderingHintsModel) {
            this.renderingHintsModel = renderingHintsModel;
            if (renderingHintsModel != null) {
                renderingHintsModel.addWeakRenderingHintsListener(this.listener);
            }
        }
    }

    public RenderingHintsModel getRenderingHintsModel() {
        return this.renderingHintsModel;
    }

    @Override
    public void setAlpha(float alpha) {
        if (this.alpha != alpha) {
            assert (alpha >= 0.0f && (double)alpha <= 1.0);
            float oldAlpha = this.alpha;
            this.alpha = alpha;
            if (alpha > 0.0f && alpha < 1.0f) {
                if (oldAlpha == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
            } else if (alpha == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", oldAlpha, alpha);
            this.repaint();
        }
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.renderingHintsModel != null) {
            g2.setRenderingHints(this.renderingHintsModel.getRenderingHints());
        }
        if (this.alpha != 1.0f) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComp = g2d.getComposite();
            float alpha = this.getAlpha();
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
            g2d.setComposite(alphaComp);
            super.paint(g2d);
            g2d.setComposite(oldComp);
        } else {
            super.paint(g);
        }
    }
}

