/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.action;

import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class ExitAction
extends AbstractAction {
    public static final int EXIT_ON_CLOSE = 3;
    public static final int DISPOSE_ON_CLOSE = 2;
    protected JFrame mainFrame;
    private final ResourcesModel resourcesModel;
    private int closeOperation;

    public ExitAction() {
        this((PropertiesModel)null);
    }

    public ExitAction(PropertiesModel propertiesModel) {
        this(null, null, propertiesModel);
    }

    public ExitAction(ResourcesModel resourcesModel, PropertiesModel propertiesModel) {
        this(null, resourcesModel, propertiesModel);
    }

    public ExitAction(JFrame mainFrame, ResourcesModel resourcesModel, final PropertiesModel propertiesModel) {
        this.mainFrame = mainFrame;
        this.resourcesModel = resourcesModel;
        this.closeOperation = 3;
        if (propertiesModel != null) {
            this.updateProperties(propertiesModel);
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    ExitAction.this.updateProperties(propertiesModel);
                }
            });
        } else {
            String name = "Exit";
            this.putValue("Name", name);
        }
        this.putValue("MnemonicKey", 120);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.resourcesModel != null && this.mainFrame != null) {
            PropertiesModel propertiesModel = this.resourcesModel.getPropertiesModel();
            propertiesModel.setValue("lookandfeel", (Object)LookAndFeelAction.getCurrentLookAndFeelName());
            propertiesModel.setValue("mainFrame.x", (Object)this.mainFrame.getX());
            propertiesModel.setValue("mainFrame.y", (Object)this.mainFrame.getY());
            propertiesModel.setValue("mainFrame.width", (Object)this.mainFrame.getWidth());
            propertiesModel.setValue("mainFrame.height", (Object)this.mainFrame.getHeight());
            this.resourcesModel.savePreferences();
        }
        if (this.mainFrame != null) {
            try {
                this.mainFrame.dispose();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        if (this.closeOperation == 3) {
            System.exit(0);
        }
    }

    public void setCloseOperation(int closeOperation) {
        this.closeOperation = closeOperation;
    }

    public void setMainFrame(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Exit";
        if (propertiesModel.isAvailable("action.exit.label")) {
            name = (String)propertiesModel.getValue("action.exit.label");
        }
        this.putValue("Name", name);
    }
}

