/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.action;

import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.action.ToggleAction;
import java.awt.event.ActionEvent;
import java.util.Locale;

public class LanguageAction
extends ToggleAction {
    private String name;
    private Locale locale;
    private ResourcesModel resourcesModel;

    public LanguageAction(String name, Locale locale, ResourcesModel resourcesModel, final PropertiesModel propertiesModel) {
        this.name = name;
        this.locale = locale;
        this.resourcesModel = resourcesModel;
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    LanguageAction.this.updateProperties(propertiesModel);
                }
            });
        }
    }

    public LanguageAction(String name, String isoCode, ResourcesModel resourcesModel, PropertiesModel propertiesModel) {
        this(name, new Locale(isoCode, resourcesModel.getLocale().getCountry()), resourcesModel, propertiesModel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resourcesModel.setLocale(this.locale);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String targetLanguage;
        String currentLanguage = this.capitalize(this.locale.getDisplayName());
        String text = currentLanguage.equals(targetLanguage = this.capitalize(this.locale.getDisplayName(this.locale))) ? currentLanguage : targetLanguage + " / " + currentLanguage;
        this.putValue("Name", text);
        this.putValue("ShortDescription", text);
    }

    private String capitalize(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    public String getISOCode() {
        return this.locale.getLanguage();
    }

    public String toString() {
        return this.getClass().getName() + "[isoCode=" + this.getISOCode() + "]";
    }
}

