/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SimpleEtchedBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected Color highlight;
    protected Color shadow;
    int margin = 0;
    int _maximumWidth = 0;

    public SimpleEtchedBorder() {
        this(1);
    }

    public SimpleEtchedBorder(int etchType) {
        this(etchType, null, null);
    }

    public SimpleEtchedBorder(Color highlight, Color shadow) {
        this(1, highlight, shadow);
    }

    public SimpleEtchedBorder(int etchType, Color highlight, Color shadow) {
        this.etchType = etchType;
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        g.translate(x, y);
        Color bg = c.getBackground();
        g.setColor(Color.black);
        g.drawLine(this.margin, this.margin, this.margin, h - this.margin - 2);
        g.setColor(bg.brighter());
        g.drawLine(this.margin + 1, this.margin + 1, this.margin + 1, h - this.margin - 3);
        g.setColor(Color.black);
        g.drawLine(w - this.margin - 2, this.margin, w - this.margin - 2, h - this.margin - 2);
        g.setColor(bg.brighter());
        g.drawLine(w - this.margin - 1, this.margin, w - this.margin - 1, h - this.margin - 1);
        g.setColor(Color.black);
        g.drawLine(this.margin, h - this.margin - 2, w - this.margin - 2, h - this.margin - 2);
        g.setColor(bg.brighter());
        g.drawLine(this.margin, h - this.margin - 1, w - this.margin - 1, h - this.margin - 1);
        g.setColor(Color.black);
        g.drawLine(this.margin, this.margin, x - this.margin / 2, this.margin);
        g.drawLine(x + this._maximumWidth + this.margin / 2, this.margin, w - this.margin - 2, this.margin);
        g.setColor(bg.brighter());
        g.drawLine(this.margin + 1, this.margin + 1, x - this.margin / 2, this.margin + 1);
        g.drawLine(x + this._maximumWidth + this.margin / 2, this.margin + 1, w - this.margin - 3, this.margin + 1);
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(Component c) {
        return this.highlight != null ? this.highlight : c.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component c) {
        return this.shadow != null ? this.shadow : c.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }
}

