/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.dialog;

import com.macrofocus.helper.WeakActionListeners;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;

public class ProgressDialog
extends JDialog {
    protected JLabel m_messageText;
    protected JLabel m_detailedMessageText;
    protected JProgressBar m_progress;
    protected JButton m_cancelButton = new JButton("Cancel");
    protected volatile boolean m_cancelRequested;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public ProgressDialog(JFrame pOwnerFrame, boolean pCanRequestCancel) {
        super((Frame)pOwnerFrame, false);
        this.setTitle("Task Progress");
        this.setDefaultCloseOperation(0);
        this.m_messageText = new JLabel("------------------------------------------------------------");
        this.m_detailedMessageText = new JLabel("------------------------------------------------------------");
        this.m_progress = new JProgressBar(0, 100);
        this.m_progress.setStringPainted(true);
        this.m_progress.setMinimumSize(new Dimension(500, 500));
        this.m_progress.setValue(0);
        this.m_cancelRequested = false;
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BoxLayout(messagePanel, 1));
        messagePanel.add(this.m_messageText);
        messagePanel.add(this.m_detailedMessageText);
        Border paneEdge = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(paneEdge);
        panel.add((Component)messagePanel, "North");
        panel.add((Component)this.m_progress, "Center");
        if (pCanRequestCancel) {
            this.m_cancelButton.setMnemonic(67);
            this.m_cancelButton.addActionListener(this.actionListeners.create(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProgressDialog.this.m_cancelRequested = true;
                    ProgressDialog.this.setDetailedMessageText("Cancel requested; please wait...");
                    ProgressDialog.this.m_cancelButton.setEnabled(false);
                }
            }, (Object)this.m_cancelButton));
            JPanel cancelPanel = new JPanel();
            cancelPanel.add(this.m_cancelButton);
            panel.add((Component)cancelPanel, "South");
        }
        this.getContentPane().add(panel);
        this.pack();
        if (pOwnerFrame != null) {
            this.setLocationRelativeTo(pOwnerFrame);
        }
    }

    public void addActionListener(ActionListener l) {
        this.m_cancelButton.addActionListener(this.actionListeners.create(l, (Object)this.m_cancelButton));
    }

    public void removeActionListener(ActionListener l) {
        this.m_cancelButton.removeActionListener(this.actionListeners.remove(l));
    }

    public void reset() {
        this.m_cancelRequested = false;
        if (this.m_cancelButton != null) {
            this.m_cancelButton.setEnabled(true);
        }
        this.setMessageText("");
        this.setDetailedMessageText("");
        this.setPercentComplete(0);
    }

    public boolean wasCancelRequested() {
        return this.m_cancelRequested;
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    public void setMessageText(String pMessageText) {
        this.m_messageText.setText(pMessageText);
    }

    public void setDetailedMessageText(String pMessageText) {
        this.m_detailedMessageText.setText(pMessageText);
    }

    public void setNumberOfSteps(int aNumberOfSteps) {
        this.m_progress.setMaximum(aNumberOfSteps);
    }

    public void increment(int anIncrement) {
        this.m_progress.setValue(this.m_progress.getValue() + anIncrement);
    }

    public void setPercentComplete(int pPercentComplete) {
        this.m_progress.setValue(pPercentComplete);
    }
}

