/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.logging.SwingLogging;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;

public class ExportDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonCancel;
    private JButton saveButton;
    private JButton copyButton;
    private JComboBox comboBoxFormat;
    private JPanel optionsContainer;
    private ContentProvider component;
    private FileChooserFactory fileChooserFactory = new FileChooserFactory(){

        @Override
        public JFileChooser getFileChooser() {
            JFileChooser fileChooser = super.getFileChooser();
            fileChooser.setFileFilter((FileFilter)ExportDialog.this.getExportFormat().getFileFilter());
            return fileChooser;
        }

        @Override
        protected JFileChooser createFileChooser() {
            JFileChooser fileChooser = super.createFileChooser();
            fileChooser.setDialogTitle("Export");
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            return fileChooser;
        }
    };
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public ExportDialog(Window owner, ExportFormat[] exportFormats) {
        super(owner);
        this.$$$setupUI$$$();
        this.setTitle("Export");
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.saveButton);
        this.comboBoxFormat.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ExportFormat format = (ExportFormat)ExportDialog.this.comboBoxFormat.getSelectedItem();
                ExportDialog.this.optionsContainer.removeAll();
                if (format.getSettingsPanel() != null) {
                    ExportDialog.this.optionsContainer.add(format.getSettingsPanel());
                }
                ExportDialog.this.pack();
            }
        });
        for (ExportFormat exportFormat : exportFormats) {
            if (!exportFormat.isValid()) continue;
            this.comboBoxFormat.addItem(exportFormat);
        }
        this.comboBoxFormat.setSelectedIndex(0);
        this.saveButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.onSave();
            }
        }, (Object)this.saveButton));
        this.copyButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.onCopy();
            }
        }, (Object)this.copyButton));
        this.buttonCancel.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.onCancel();
            }
        }, (Object)this.buttonCancel));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExportDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void setContent(ContentProvider component) {
        this.component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSave() {
        boolean dispose = true;
        JFileChooser fileChooser = this.fileChooserFactory.getFileChooser();
        fileChooser.rescanCurrentDirectory();
        int returnVal = fileChooser.showSaveDialog(this.getOwner());
        File file = fileChooser.getSelectedFile();
        FileFilter fileFilter = fileChooser.getFileFilter();
        if (returnVal == 0) {
            int input;
            if (!fileFilter.accept(file) && fileFilter instanceof AbstractFileFilter) {
                file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
            }
            if (file.exists() && (input = JOptionPane.showConfirmDialog(this, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
                return;
            }
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.getExportFormat().save(this.component, file);
            }
            catch (Exception e) {
                SwingLogging.getInstance().process((Component)this, (Throwable)e);
                dispose = false;
            }
            catch (OutOfMemoryError e) {
                SwingLogging.getInstance().process((Component)this, (Throwable)e);
                dispose = false;
            }
            finally {
                this.setCursor(cursor);
            }
        }
        if (dispose) {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCopy() {
        boolean dispose = true;
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.getExportFormat().copy(this.component);
        }
        catch (Exception e) {
            SwingLogging.getInstance().process((Component)this, (Throwable)e);
            dispose = false;
        }
        catch (OutOfMemoryError e) {
            SwingLogging.getInstance().process((Component)this, (Throwable)e);
            dispose = false;
        }
        finally {
            this.setCursor(cursor);
        }
        if (dispose) {
            this.dispose();
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private ExportFormat<Component> getExportFormat() {
        return (ExportFormat)this.comboBoxFormat.getSelectedItem();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.saveButton = new JButton();
        this.saveButton.setText("Save...");
        panel2.add((Component)this.saveButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        panel2.add((Component)this.buttonCancel, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.copyButton = new JButton();
        this.copyButton.setText("Copy");
        panel2.add((Component)this.copyButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Format:");
        panel3.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel3.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.comboBoxFormat = new JComboBox();
        panel3.add((Component)this.comboBoxFormat, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.optionsContainer = new JPanel();
        this.optionsContainer.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)this.optionsContainer, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

