/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.macrofocus.util.file.filter.TiffFileFilter;
import com.macrofocus.util.swing.export.format.AbstractRasterExportFormat;
import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;

public class TIFFExportFormat
extends AbstractRasterExportFormat {
    public TiffFileFilter getFileFilter() {
        return tiffFileFilter;
    }

    @Override
    public Component getSettingsPanel() {
        return this.getSettingsEditor().getSettingsPanel();
    }

    public String toString() {
        return this.getFileFilter().getName();
    }

    @Override
    protected void write(BufferedImage img, String format, float dpi, File outFile) throws IOException {
        if (outFile.exists()) {
            outFile.delete();
        }
        super.write(img, format, dpi, outFile);
    }

    @Override
    protected IIOMetadata createMetadata(ImageWriter writer, float xDPI, float yDPI, RenderedImage ri, ImageWriteParam writeParam) throws IIOInvalidTreeException {
        TIFFDirectory dir = TIFFDirectory.createFromMetadata((IIOMetadata)writer.getDefaultImageMetadata(new ImageTypeSpecifier(ri), writeParam));
        BaselineTIFFTagSet base = BaselineTIFFTagSet.getInstance();
        TIFFTag tagXRes = base.getTag(282);
        TIFFTag tagYRes = base.getTag(283);
        TIFFField fieldXRes = new TIFFField(tagXRes, 5, 1, (Object)new long[][]{{(int)xDPI, 1L}});
        TIFFField fieldYRes = new TIFFField(tagYRes, 5, 1, (Object)new long[][]{{(int)yDPI, 1L}});
        dir.addTIFFField(fieldXRes);
        dir.addTIFFField(fieldYRes);
        return dir.getAsMetadata();
    }

    @Override
    protected ImageWriteParam createWriteParam(ImageWriter writer) {
        TIFFImageWriteParam params = new TIFFImageWriteParam(Locale.US);
        params.setCompressionMode(2);
        params.setCompressionType("LZW");
        params.setCompressionQuality(0.0f);
        return params;
    }
}

