/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;

public class BackupColoredIcon
implements Icon {
    public static final int TYPE_RECTANGULAR = 0;
    public static final int TYPE_ROUND = 1;
    public static final int TYPE_DIAMOND = 2;
    private Color color;
    private int width;
    private int height;
    private int rectX;
    private int rectY;
    private int rectWidth;
    private int rectHeight;
    private int type;

    public BackupColoredIcon(Color color, int width, int height) {
        this(color, width, height, 0, 0, width, height);
    }

    public BackupColoredIcon(Color color, int width, int height, int rectX, int rectY, int rectWidth, int rectHeight) {
        this(color, width, height, rectX, rectY, rectWidth, rectHeight, 0);
    }

    public BackupColoredIcon(Color color, int width, int height, int rectX, int rectY, int rectWidth, int rectHeight, int type) {
        this.color = color;
        this.width = width;
        this.height = height;
        this.rectX = rectX;
        this.rectY = rectY;
        this.rectWidth = rectWidth;
        this.rectHeight = rectHeight;
        this.type = type;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        switch (this.type) {
            case 0: {
                g.fillRect(x + this.rectX, y + this.rectY, this.rectWidth, this.rectHeight);
                break;
            }
            case 1: {
                g.fillOval(x + this.rectX, y + this.rectY, this.rectWidth, this.rectHeight);
                break;
            }
            case 2: {
                Polygon poly = new Polygon();
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                poly.addPoint(x + this.rectX + this.rectWidth, y + this.rectY + this.rectHeight / 2);
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                poly.addPoint(x + this.rectX, y + this.rectY + this.rectHeight / 2);
                g.fillPolygon(poly);
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

