/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import javax.swing.Icon;

public class ColoredIcon
implements Icon {
    public static final int TYPE_RECTANGULAR = 0;
    public static final int TYPE_ROUND = 1;
    public static final int TYPE_DIAMOND = 2;
    public static final int TYPE_TRIANGLE_LEFT = 3;
    public static final int TYPE_TRIANGLE_RIGHT = 4;
    public static final int TYPE_TWO_COLORS_DIAMOND = 5;
    public static final int TYPE_CHECKBOARD = 6;
    private Paint fillColor;
    private Color secondaryFillColor;
    private Color outlineColor;
    private int width;
    private int height;
    private int rectX;
    private int rectY;
    private int rectWidth;
    private int rectHeight;
    private int type;

    public ColoredIcon(Color fillColor, int width, int height) {
        this(fillColor, null, width, height, 0, 0, width, height);
    }

    public ColoredIcon(Color fillColor, Color outlineColor, int width, int height) {
        this(fillColor, outlineColor, width, height, 0, 0, width, height);
    }

    public ColoredIcon(Paint fillColor, int width, int height, int rectX, int rectY, int rectWidth, int rectHeight) {
        this(fillColor, null, null, width, height, rectX, rectY, rectWidth, rectHeight, 0);
    }

    public ColoredIcon(Color fillColor, Color outlineColor, int width, int height, int rectX, int rectY, int rectWidth, int rectHeight) {
        this(fillColor, null, outlineColor, width, height, rectX, rectY, rectWidth, rectHeight, 0);
    }

    public ColoredIcon(Color fillColor, int width, int height, int rectX, int rectY, int rectWidth, int rectHeight, int type) {
        this(fillColor, null, null, width, height, rectX, rectY, rectWidth, rectHeight, type);
    }

    public ColoredIcon(Color fillColor, Color outlineColor, int width, int height, int rectX, int rectY, int rectWidth, int rectHeight, int type) {
        this(fillColor, null, outlineColor, width, height, rectX, rectY, rectWidth, rectHeight, type);
    }

    public ColoredIcon(Paint fillColor, Color secondaryFillColor, Color outlineColor, int width, int height, int rectX, int rectY, int rectWidth, int rectHeight, int type) {
        this.fillColor = fillColor;
        this.secondaryFillColor = secondaryFillColor;
        this.outlineColor = outlineColor;
        this.width = width;
        this.height = height;
        this.rectX = rectX;
        this.rectY = rectY;
        this.rectWidth = rectWidth;
        this.rectHeight = rectHeight;
        this.type = type;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.fillColor);
        switch (this.type) {
            case 0: {
                g.fillRect(x + this.rectX, y + this.rectY, this.rectWidth, this.rectHeight);
                break;
            }
            case 1: {
                g.fillOval(x + this.rectX, y + this.rectY, this.rectWidth, this.rectHeight);
                break;
            }
            case 2: {
                Polygon poly = new Polygon();
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                poly.addPoint(x + this.rectX + this.rectWidth, y + this.rectY + this.rectHeight / 2);
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                poly.addPoint(x + this.rectX, y + this.rectY + this.rectHeight / 2);
                g.fillPolygon(poly);
                break;
            }
            case 3: {
                Polygon poly = new Polygon();
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                poly.addPoint(x + this.rectX, y + this.rectY + this.rectHeight / 2);
                g.fillPolygon(poly);
                break;
            }
            case 4: {
                Polygon poly = new Polygon();
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                poly.addPoint(x + this.rectX + this.rectWidth, y + this.rectY + this.rectHeight / 2);
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                g.fillPolygon(poly);
                break;
            }
            case 5: {
                Polygon poly = new Polygon();
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                poly.addPoint(x + this.rectX, y + this.rectY + this.rectHeight / 2);
                g.fillPolygon(poly);
                g.setColor(this.secondaryFillColor);
                Polygon poly2 = new Polygon();
                poly2.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                poly2.addPoint(x + this.rectX + this.rectWidth, y + this.rectY + this.rectHeight / 2);
                poly2.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                g.fillPolygon(poly2);
                break;
            }
            case 6: {
                int row = 0;
                for (int y1 = this.rectY; y1 < this.rectY + this.rectHeight; y1 += 2) {
                    for (int x1 = this.rectX; x1 < this.rectX + this.rectWidth; x1 += 4) {
                        if (row % 2 == 0) {
                            g.fillRect(x + x1, y + y1, 2, 2);
                            continue;
                        }
                        g.fillRect(x + x1 + 2, y + y1, 2, 2);
                    }
                    ++row;
                }
                break;
            }
        }
        if (this.outlineColor != null) {
            g.setColor(this.outlineColor);
            switch (this.type) {
                case 0: {
                    g.drawRect(x + this.rectX, y + this.rectY, this.rectWidth, this.rectHeight);
                    break;
                }
                case 1: {
                    g.drawOval(x + this.rectX, y + this.rectY, this.rectWidth, this.rectHeight);
                    break;
                }
                case 2: {
                    Polygon poly = new Polygon();
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                    poly.addPoint(x + this.rectX + this.rectWidth, y + this.rectY + this.rectHeight / 2);
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                    poly.addPoint(x + this.rectX, y + this.rectY + this.rectHeight / 2);
                    g.drawPolygon(poly);
                    break;
                }
                case 3: {
                    Polygon poly = new Polygon();
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                    poly.addPoint(x + this.rectX, y + this.rectY + this.rectHeight / 2);
                    g.drawPolygon(poly);
                    break;
                }
                case 4: {
                    Polygon poly = new Polygon();
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                    poly.addPoint(x + this.rectX + this.rectWidth, y + this.rectY + this.rectHeight / 2);
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                    g.drawPolygon(poly);
                    break;
                }
                case 5: {
                    Polygon poly = new Polygon();
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY);
                    poly.addPoint(x + this.rectX + this.rectWidth, y + this.rectY + this.rectHeight / 2);
                    poly.addPoint(x + this.rectX + this.rectWidth / 2, y + this.rectY + this.rectHeight);
                    poly.addPoint(x + this.rectX, y + this.rectY + this.rectHeight / 2);
                    g.drawPolygon(poly);
                    break;
                }
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

