/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ClassnameLookAndFeelAction
extends LookAndFeelAction {
    private final String className;
    private final boolean decorated;

    public ClassnameLookAndFeelAction(String name, String label, String className) {
        this(name, label, className, false);
    }

    public ClassnameLookAndFeelAction(String name, String label, String className, boolean decorated) {
        super(name, label);
        this.className = className;
        this.decorated = decorated;
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ClassnameLookAndFeelAction.this.setSelected(ClassnameLookAndFeelAction.this.active());
            }
        });
        this.setSelected(this.active());
        this.setEnabled(this.exist());
    }

    @Override
    public boolean exist() {
        if (this.className != null) {
            Class<?> cl = null;
            try {
                cl = Class.forName(this.className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            catch (UnsupportedClassVersionError e) {
                return false;
            }
            return cl != null;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!ClassnameLookAndFeelAction.this.isApplet()) {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                }
                if (ClassnameLookAndFeelAction.this.decorated) {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
                try {
                    UIManager.setLookAndFeel(ClassnameLookAndFeelAction.this.className);
                    if (ClassnameLookAndFeelAction.this.rootComponents != null) {
                        for (Component rootComponent : (Iterable)ClassnameLookAndFeelAction.this.rootComponents.get()) {
                            SwingUtilities.updateComponentTreeUI(rootComponent);
                            if (!(rootComponent instanceof JFrame)) continue;
                            JFrame frame = (JFrame)rootComponent;
                            frame.setVisible(false);
                            frame.setVisible(true);
                        }
                    }
                }
                catch (UnsupportedLookAndFeelException e) {
                    System.out.println("Couldn't load " + ClassnameLookAndFeelAction.this.description + " " + e);
                }
                catch (NoClassDefFoundError e) {
                    System.out.println("Couldn't load " + ClassnameLookAndFeelAction.this.description + " " + e);
                }
                catch (Exception e) {
                    System.out.println("Couldn't load " + ClassnameLookAndFeelAction.this.description + " " + e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public String getClassname() {
        return this.className;
    }

    @Override
    public boolean active() {
        return UIManager.getLookAndFeel().getClass().getName().equals(this.className);
    }
}

