/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.swing.action.ToggleAction;
import com.macrofocus.util.swing.plaf.action.ClassnameLookAndFeelAction;
import com.macrofocus.util.swing.plaf.action.MacrofocusDarkLookAndFeelAction;
import com.macrofocus.util.swing.plaf.action.MacrofocusLightLookAndFeelAction;
import com.macrofocus.util.swing.plaf.action.MetabolicInsightLookAndFeelAction;
import com.macrofocus.util.swing.plaf.action.MetalLookAndFeelAction;
import com.macrofocus.util.swing.plaf.action.SyntheticaLookAndFeelAction;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.swing.UIManager;

public abstract class LookAndFeelAction
extends ToggleAction {
    public static LookAndFeelAction SYSTEM = new ClassnameLookAndFeelAction("system", "System", UIManager.getSystemLookAndFeelClassName());
    public static LookAndFeelAction CROSSPLATFORM = new ClassnameLookAndFeelAction("crossplatform", "Cross Platform", UIManager.getCrossPlatformLookAndFeelClassName());
    public static LookAndFeelAction METAL = new MetalLookAndFeelAction();
    public static LookAndFeelAction OCEAN = new MetalLookAndFeelAction("ocean", "Ocean", "ocean");
    public static LookAndFeelAction GTK = new ClassnameLookAndFeelAction("gtk", "GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    public static LookAndFeelAction WINDOWS = new ClassnameLookAndFeelAction("windows", "Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    public static LookAndFeelAction MOTIF = new ClassnameLookAndFeelAction("motif", "Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    public static LookAndFeelAction KUNSTOFF = new ClassnameLookAndFeelAction("kunstoff", "Kunstoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
    public static LookAndFeelAction SUBSTANCE = new ClassnameLookAndFeelAction("substance", "Substance", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel", true);
    public static LookAndFeelAction SUBSTANCE_BUSINESS = new ClassnameLookAndFeelAction("substance-business", "Substance Business", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel", true);
    public static LookAndFeelAction SUBSTANCE_BUSINESSBLUESTEEL = new ClassnameLookAndFeelAction("substance-businessbluesteel", "Substance Business Blue Steel", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlueSteelLookAndFeel", true);
    public static LookAndFeelAction SUBSTANCE_GRAPHITE = new ClassnameLookAndFeelAction("substance-graphite", "Substance Graphite", "org.pushingpixels.substance.api.skin.SubstanceGraphiteLookAndFeel", true);
    public static LookAndFeelAction SUBSTANCE_GRAPHITEGLASS = new ClassnameLookAndFeelAction("substance-graphiteglass", "Substance GraphiteGlass", "org.pushingpixels.substance.api.skin.SubstanceGraphiteGlassLookAndFeel", true);
    public static LookAndFeelAction SUBSTANCE_GRAPHITEAQUA = new ClassnameLookAndFeelAction("substance-graphiteaqua", "Substance GraphiteAqua", "org.pushingpixels.substance.api.skin.SubstanceGraphiteAquaGlassLookAndFeel", true);
    public static LookAndFeelAction SUBSTANCE_MISTAQUA = new ClassnameLookAndFeelAction("substance-mistaqua", "Substance Mist Aqua", "org.pushingpixels.substance.api.skin.SubstanceMistAquaLookAndFeel", true);
    public static LookAndFeelAction FLAT_LIGHT = new ClassnameLookAndFeelAction("flat-light", "FlatLaf Light", "com.formdev.flatlaf.FlatLightLaf", true);
    public static LookAndFeelAction FLAT_DARK = new ClassnameLookAndFeelAction("flat-dark", "FlatLaf Dark", "com.formdev.flatlaf.FlatDarkLaf", true);
    public static LookAndFeelAction FLAT_INTELLIJ = new ClassnameLookAndFeelAction("flat-intellij", "FlatLaf Intellij", "com.formdev.flatlaf.FlatIntelliJLaf", true);
    public static LookAndFeelAction FLAT_DARCULA = new ClassnameLookAndFeelAction("flat-darcula", "FlatLaf Darcula", "com.formdev.flatlaf.FlatDarculaLaf", true);
    public static LookAndFeelAction SYNTHETICA_STANDARD = new SyntheticaLookAndFeelAction("synthetica", "Standard", "de.javasoft.synthetica.standard.SyntheticaStandardLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_SIMPLE2D = new SyntheticaLookAndFeelAction("synthetica-simple2d", "Simple 2D", "de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_BLACKEYE = new SyntheticaLookAndFeelAction("synthetica-blackeye", "Black Eye", "de.javasoft.synthetica.blackeye.SyntheticaBlackEyeLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_BLACKMOON = new SyntheticaLookAndFeelAction("synthetica-blackmoon", "Black Moon", "de.javasoft.synthetica.blackmoon.SyntheticaBlackMoonLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_BLACKSTAR = new SyntheticaLookAndFeelAction("synthetica-blackstar", "Black Star", "de.javasoft.synthetica.blackstar.SyntheticaBlackStarLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_BLUEICE = new SyntheticaLookAndFeelAction("synthetica-blueice", "Blue Ice", "de.javasoft.synthetica.blueice.SyntheticaBlueIceLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_BLUEMOON = new SyntheticaLookAndFeelAction("synthetica-bluemoon", "Blue Moon", "de.javasoft.synthetica.bluemoon.SyntheticaBlueMoonLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_BLUESTEEL = new SyntheticaLookAndFeelAction("synthetica-bluesteel", "Blue Steel", "de.javasoft.synthetica.bluesteel.SyntheticaBlueSteelLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_CLASSY = new SyntheticaLookAndFeelAction("synthetica-classy", "Classy", "de.javasoft.synthetica.classy.SyntheticaClassyLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_DARK = new SyntheticaLookAndFeelAction("synthetica-dark", "Dark", "de.javasoft.synthetica.dark.SyntheticaDarkLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_GREENDREAM = new SyntheticaLookAndFeelAction("synthetica-greendream", "Green Dream", "de.javasoft.synthetica.greendream.SyntheticaGreenDreamLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_MAUVEMETALLIC = new SyntheticaLookAndFeelAction("synthetica-mauvemetallic", "Mauve Metallic", "de.javasoft.synthetica.mauvemetallic.SyntheticaMauveMetallicLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_ORANGEMETALLIC = new SyntheticaLookAndFeelAction("synthetica-orangemetallic", "Orange Metallic", "de.javasoft.synthetica.orangemetallic.SyntheticaOrangeMetallicLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_PLAIN = new SyntheticaLookAndFeelAction("synthetica-plain", "Plain", "de.javasoft.synthetica.plain.SyntheticaPlainLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_SILVERMOON = new SyntheticaLookAndFeelAction("synthetica-silvermoon", "Silver Moon", "de.javasoft.synthetica.silvermoon.SyntheticaSilverMoonLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_SKYMETALLIC = new SyntheticaLookAndFeelAction("synthetica-skymetalic", "Sky Metalic", "de.javasoft.synthetica.skymetallic.SyntheticaSkyMetallicLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_WHITEVISION = new SyntheticaLookAndFeelAction("synthetica-whitevision", "White Vision", "de.javasoft.synthetica.whitevision.SyntheticaWhiteVisionLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_ALUOXIDE = new SyntheticaLookAndFeelAction("synthetica-aluoxide", "Alu Oxide", "de.javasoft.synthetica.aluoxide.SyntheticaAluOxideLookAndFeel");
    public static LookAndFeelAction SYNTHETICA_BLUELIGHT = new SyntheticaLookAndFeelAction("synthetica-bluelight", "Blue Light", "de.javasoft.synthetica.bluelight.SyntheticaBlueLightLookAndFeel");
    public static LookAndFeelAction NIMBUS = new ClassnameLookAndFeelAction("nimbus", "Nimbus", "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
    public static LookAndFeelAction MACROFOCUS = new MetalLookAndFeelAction();
    public static LookAndFeelAction MACROFOCUS_DARK = new MacrofocusDarkLookAndFeelAction();
    public static LookAndFeelAction MACROFOCUS_LIGHT = new MacrofocusLightLookAndFeelAction();
    public static LookAndFeelAction METABOLICINSIGHT = new MetabolicInsightLookAndFeelAction(SYNTHETICA_SILVERMOON);
    public static LookAndFeelAction[] LOOK_AND_FEEL_ACTIONS = new LookAndFeelAction[]{MACROFOCUS, MACROFOCUS_LIGHT, MACROFOCUS_DARK, METABOLICINSIGHT, SYSTEM, CROSSPLATFORM, METAL, OCEAN, GTK, WINDOWS, MOTIF, KUNSTOFF, SUBSTANCE, SUBSTANCE_BUSINESS, SUBSTANCE_BUSINESSBLUESTEEL, SUBSTANCE_GRAPHITE, SUBSTANCE_GRAPHITEGLASS, SUBSTANCE_GRAPHITEAQUA, SUBSTANCE_MISTAQUA, FLAT_LIGHT, FLAT_DARK, FLAT_INTELLIJ, FLAT_DARCULA, SYNTHETICA_STANDARD, SYNTHETICA_ALUOXIDE, SYNTHETICA_SIMPLE2D, SYNTHETICA_BLACKEYE, SYNTHETICA_BLACKMOON, SYNTHETICA_BLACKSTAR, SYNTHETICA_BLUEICE, SYNTHETICA_BLUELIGHT, SYNTHETICA_BLUEMOON, SYNTHETICA_BLUESTEEL, SYNTHETICA_CLASSY, SYNTHETICA_DARK, SYNTHETICA_GREENDREAM, SYNTHETICA_MAUVEMETALLIC, SYNTHETICA_ORANGEMETALLIC, SYNTHETICA_PLAIN, SYNTHETICA_SILVERMOON, SYNTHETICA_SKYMETALLIC, SYNTHETICA_WHITEVISION, NIMBUS};
    public static LookAndFeelAction[] SYNTH_LOOK_AND_FEEL_ACTIONS = new LookAndFeelAction[]{SYNTHETICA_STANDARD, SYNTHETICA_ALUOXIDE, SYNTHETICA_SIMPLE2D, SYNTHETICA_BLACKEYE, SYNTHETICA_BLACKMOON, SYNTHETICA_BLACKSTAR, SYNTHETICA_BLUEICE, SYNTHETICA_BLUELIGHT, SYNTHETICA_BLUEMOON, SYNTHETICA_BLUESTEEL, SYNTHETICA_CLASSY, SYNTHETICA_DARK, SYNTHETICA_GREENDREAM, SYNTHETICA_MAUVEMETALLIC, SYNTHETICA_ORANGEMETALLIC, SYNTHETICA_PLAIN, SYNTHETICA_SILVERMOON, SYNTHETICA_SKYMETALLIC, SYNTHETICA_WHITEVISION, NIMBUS};
    public static LookAndFeelAction[] SYNTHETICA_LOOK_AND_FEEL_ACTIONS = new LookAndFeelAction[]{SYNTHETICA_STANDARD, SYNTHETICA_ALUOXIDE, SYNTHETICA_SIMPLE2D, SYNTHETICA_BLACKEYE, SYNTHETICA_BLACKMOON, SYNTHETICA_BLACKSTAR, SYNTHETICA_BLUEICE, SYNTHETICA_BLUELIGHT, SYNTHETICA_BLUEMOON, SYNTHETICA_BLUESTEEL, SYNTHETICA_CLASSY, SYNTHETICA_DARK, SYNTHETICA_GREENDREAM, SYNTHETICA_MAUVEMETALLIC, SYNTHETICA_ORANGEMETALLIC, SYNTHETICA_PLAIN, SYNTHETICA_SILVERMOON, SYNTHETICA_SKYMETALLIC, SYNTHETICA_WHITEVISION};
    public static LookAndFeelAction[] TREEMAP_LOOK_AND_FEEL_ACTIONS = new LookAndFeelAction[]{SYNTHETICA_STANDARD, SYNTHETICA_ALUOXIDE, SYNTHETICA_SIMPLE2D, SYNTHETICA_BLACKEYE, SYNTHETICA_BLACKMOON, SYNTHETICA_BLACKSTAR, SYNTHETICA_BLUEICE, SYNTHETICA_BLUELIGHT, SYNTHETICA_BLUEMOON, SYNTHETICA_BLUESTEEL, SYNTHETICA_CLASSY, SYNTHETICA_DARK, SYNTHETICA_GREENDREAM, SYNTHETICA_MAUVEMETALLIC, SYNTHETICA_ORANGEMETALLIC, SYNTHETICA_PLAIN, SYNTHETICA_SILVERMOON, SYNTHETICA_SKYMETALLIC, SYNTHETICA_WHITEVISION};
    public static LookAndFeelAction[] HIGH_D_LOOK_AND_FEEL_ACTIONS = new LookAndFeelAction[]{SYNTHETICA_ALUOXIDE, SYNTHETICA_BLACKEYE, SYNTHETICA_BLUELIGHT, SYNTHETICA_DARK, SYNTHETICA_PLAIN, SYNTHETICA_WHITEVISION};
    public static LookAndFeelAction[] INFOSCOPE_LOOK_AND_FEEL_ACTIONS = new LookAndFeelAction[]{SYSTEM, MACROFOCUS, MACROFOCUS_LIGHT, MACROFOCUS_DARK, SYNTHETICA_STANDARD, SYNTHETICA_ALUOXIDE, SYNTHETICA_SIMPLE2D, SYNTHETICA_BLACKEYE, SYNTHETICA_BLACKMOON, SYNTHETICA_BLACKSTAR, SYNTHETICA_BLUEICE, SYNTHETICA_BLUELIGHT, SYNTHETICA_BLUEMOON, SYNTHETICA_BLUESTEEL, SYNTHETICA_CLASSY, SYNTHETICA_DARK, SYNTHETICA_GREENDREAM, SYNTHETICA_MAUVEMETALLIC, SYNTHETICA_ORANGEMETALLIC, SYNTHETICA_PLAIN, SYNTHETICA_SILVERMOON, SYNTHETICA_SKYMETALLIC, SYNTHETICA_WHITEVISION, NIMBUS};
    protected Supplier<Iterable<Component>> rootComponents;
    protected ResourcesModel resourcesModel;
    private final String name;
    protected final String description;
    private boolean isApplet = false;

    public static LookAndFeelAction findLookAndFeelAction(String name, boolean isApplet) {
        for (LookAndFeelAction action : LOOK_AND_FEEL_ACTIONS) {
            if (!name.equals(action.getName())) continue;
            action.setApplet(isApplet);
            if (!action.exist()) continue;
            return action;
        }
        return null;
    }

    public static String getCurrentLookAndFeelName() {
        String className = UIManager.getLookAndFeel().getClass().getName();
        for (LookAndFeelAction action : LOOK_AND_FEEL_ACTIONS) {
            if (!className.equals(action.getClassname())) continue;
            return action.getName();
        }
        return null;
    }

    public LookAndFeelAction(String name, String label) {
        super(label);
        this.name = name;
        this.description = label + " Look and Feel";
        this.putValue("ShortDescription", this.description);
    }

    public void setRootComponents(Supplier<Iterable<Component>> rootComponents) {
        this.rootComponents = rootComponents;
    }

    public void setRootComponents(final Iterable<Component> rootComponents) {
        this.rootComponents = new Supplier<Iterable<Component>>(){

            @Override
            public Iterable<Component> get() {
                return rootComponents;
            }
        };
    }

    public void setRootComponents(final Component ... rootComponents) {
        this.rootComponents = new Supplier<Iterable<Component>>(){

            @Override
            public Iterable<Component> get() {
                if (rootComponents != null && rootComponents.length > 0 && rootComponents[0] != null) {
                    return new Iterable<Component>(){

                        @Override
                        public Iterator<Component> iterator() {
                            return Arrays.asList(rootComponents).iterator();
                        }
                    };
                }
                return Collections.emptyList();
            }
        };
    }

    public void setResourcesModel(ResourcesModel resourcesModel) {
        this.resourcesModel = resourcesModel;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean exist();

    public boolean active() {
        return false;
    }

    public void setApplet(boolean applet) {
        this.isApplet = applet;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public String getClassname() {
        return null;
    }
}

