/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.macrofocus.util.swing.plaf.MacrofocusLightOceanMetalTheme;
import com.macrofocus.util.swing.plaf.MacrofocusLookAndFeel;
import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MacrofocusLightOceanLookAndFeelAction
extends LookAndFeelAction {
    public MacrofocusLightOceanLookAndFeelAction(Supplier<Iterable<Component>> rootComponents) {
        super("macrofocus-light-ocean", "Macrofocus Ocean");
        this.setRootComponents(rootComponents);
        this.putValue("ShortDescription", "Macrofocus Ocean Look and Feel");
    }

    public MacrofocusLightOceanLookAndFeelAction(Iterable<Component> rootComponents) {
        super("macrofocus-light-ocean", "Macrofocus Ocean");
        this.setRootComponents(rootComponents);
        this.putValue("ShortDescription", "Macrofocus Ocean Look and Feel");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        MacrofocusLookAndFeel.initLookAndFeel(true, true);
        try {
            UIManager.put("ScrollBar.width", 13);
            Color thumbColor = new Color(66, 106, 178);
            UIManager.put("ScrollBar.thumb", thumbColor);
            UIManager.put("ScrollBar.thumbHighlight", thumbColor.brighter());
            UIManager.put("ScrollBar.thumbShadow", thumbColor.darker());
            MacrofocusLightOceanMetalTheme theme = new MacrofocusLightOceanMetalTheme();
            UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
            MetalLookAndFeel.setCurrentTheme(theme);
            MetalLookAndFeel newLookAndFeel = new MetalLookAndFeel();
            UIManager.setLookAndFeel(newLookAndFeel);
            if (this.rootComponents != null) {
                for (Component rootComponent : (Iterable)this.rootComponents.get()) {
                    SwingUtilities.updateComponentTreeUI(rootComponent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Couldn't load Macrofocus Light Ocean L&F");
        }
    }

    @Override
    public boolean exist() {
        return true;
    }
}

