/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.UnsupportedLookAndFeelException;

public class NamedLookAndFeelAction
extends AbstractAction {
    private Component rootComponent;
    private String lf;
    private boolean debug = false;
    private boolean applet;

    public NamedLookAndFeelAction(String lf) {
        this.lf = lf;
    }

    public NamedLookAndFeelAction(String lf, Component rootComponent) {
        this.lf = lf;
        this.rootComponent = rootComponent;
    }

    public void setRootComponent(Component rootComponent) {
        this.rootComponent = rootComponent;
    }

    public void perform() {
        this.actionPerformed(new ActionEvent(this, 0, null));
    }

    public void debug() {
        this.debug = true;
        this.actionPerformed(new ActionEvent(this, 0, null));
    }

    public void setApplet(boolean applet) {
        this.applet = applet;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.lf != null) {
            LookAndFeelAction action = null;
            try {
                action = LookAndFeelAction.findLookAndFeelAction(this.lf, this.applet);
            }
            catch (ExceptionInInitializerError e) {
                e.printStackTrace();
            }
            if (action != null) {
                action.setRootComponents(this.rootComponent);
                action.setApplet(this.applet);
                action.actionPerformed(new ActionEvent(this, 0, null));
                if (this.debug) {
                    System.err.println(this.getClass().getName() + ": Debug mode unsupported");
                }
            } else {
                Logging.getInstance().process((Throwable)new UnsupportedLookAndFeelException(this.lf));
            }
            this.lf = null;
            this.rootComponent = null;
        }
    }
}

