/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.table;

import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.util.swing.table.ComboBoxTableCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class ComboBoxTableCellEditor
extends ComboBoxTableCellRenderer
implements TableCellEditor {
    private final ChangeEvent event = new ChangeEvent(this);
    private final EventListenerList listenerList = new EventListenerList();
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public ComboBoxTableCellEditor(Object[] items) {
        super(items);
        this.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxTableCellEditor.this.fireEditingStopped();
            }
        }, (Object)this));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public Object getCellEditorValue() {
        return this.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public final void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public final void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    private void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.event);
        }
    }

    private void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.event);
        }
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }
}

