/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.window;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.MPanel;
import com.macrofocus.util.swing.border.KunststoffButtonBorder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.OverlayLayout;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.StyleConstants;

public class AboutPanel
extends MPanel {
    private final JLabel backgroundLabel;
    private final JButton okButton;
    private Color copyrightColor = Color.white;
    private Color licenseColor = Color.white;
    private Color thirdPartyColor = Color.white;
    private Color versionColor = new Color(200, 200, 190);
    private Color okBackgroundColor = new Color(118, 146, 183);
    private Color okForegroundColor = Color.white;
    private int versionY = 100;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public AboutPanel(ResourcesModel resourceModel, String filename, final ApplicationModel applicationModel) {
        Rectangle licenseBounds;
        ImageIcon backgroundImage;
        PropertiesModel propertiesModel = resourceModel.getPropertiesModel();
        if (propertiesModel.isAvailable("about.copyright.color")) {
            this.copyrightColor = (Color)propertiesModel.getValue("about.copyright.color");
        }
        if (propertiesModel.isAvailable("about.license.color")) {
            this.licenseColor = (Color)propertiesModel.getValue("about.license.color");
        }
        if (propertiesModel.isAvailable("about.thirdparty.color")) {
            this.thirdPartyColor = (Color)propertiesModel.getValue("about.thirdparty.color");
        }
        if (propertiesModel.isAvailable("about.version.color")) {
            this.versionColor = (Color)propertiesModel.getValue("about.version.color");
        }
        URL resource = resourceModel.getUrl(filename);
        try {
            backgroundImage = new ImageIcon(resource);
        }
        catch (NullPointerException e) {
            System.err.println("Could not find " + filename + " (" + resource + ") " + resourceModel);
            e.printStackTrace();
            backgroundImage = null;
        }
        this.backgroundLabel = new JLabel((Icon)backgroundImage){

            @Override
            protected void paintComponent(Graphics g) {
                String releaseDate;
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setColor(AboutPanel.this.versionColor);
                String version = applicationModel.getVersionModel().getMajorMinorPatchString();
                int versionWidth = g.getFontMetrics().stringWidth(version) + 6;
                int x = Math.min(364, this.getWidth() - versionWidth);
                int y = AboutPanel.this.getVersionY();
                g.drawString(version, x, y);
                g.setFont(g.getFont().deriveFont(9.0f));
                y += g.getFontMetrics().getHeight();
                String build = applicationModel.getVersionModel().getBuildString();
                if (build != null) {
                    int buildWidth = g.getFontMetrics().stringWidth("build " + build) + 6;
                    x = x + versionWidth - buildWidth;
                    g.drawString("build " + build, x, y);
                }
                if ((releaseDate = applicationModel.getVersionModel().getReleaseDateString()) != null) {
                    g.setFont(g.getFont().deriveFont(9.0f));
                    int releaseDateWidth = g.getFontMetrics().stringWidth("Released on " + releaseDate) + 6;
                    x = x + versionWidth - releaseDateWidth;
                    g.drawString("Released on " + releaseDate, x, y += g.getFontMetrics().getHeight());
                }
            }
        };
        this.backgroundLabel.setLayout(null);
        LicenseModel licenseModel = applicationModel.getLicenseModel();
        if (licenseModel != null) {
            licenseBounds = new Rectangle(20, 130, 365, 40);
            Date expirationDate = licenseModel.getExpirationDate();
            String username = licenseModel.getUsername();
            JTextPane license = new JTextPane();
            String text = "Licensed to " + username + "\n";
            if (expirationDate != null) {
                DateFormat df = DateFormat.getDateInstance(1, Locale.US);
                switch (licenseModel.getExpiration()) {
                    case CurrentDate: {
                        text = text + "Expiration date: " + df.format(expirationDate);
                        break;
                    }
                    case ReleaseDate: {
                        text = text + "Perpetual use for all releases until " + df.format(expirationDate);
                    }
                }
            }
            license.setText(text);
            StyleConstants.setAlignment(license.getLogicalStyle(), 1);
            license.setOpaque(false);
            license.putClientProperty("Synthetica.opaque", Boolean.FALSE);
            license.setEditable(false);
            license.setForeground(this.licenseColor);
            license.setFont(MetalLookAndFeel.getControlTextFont());
            this.backgroundLabel.add(license);
            license.setBounds(licenseBounds);
        }
        licenseBounds = new Rectangle(20, 170, 365, 50);
        JTextPane license = new JTextPane();
        StyleConstants.setAlignment(license.getLogicalStyle(), 1);
        license.setText((String)propertiesModel.getValue("about.license"));
        license.setOpaque(false);
        license.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        license.setEditable(false);
        license.setForeground(this.licenseColor);
        license.setFont(MetalLookAndFeel.getControlTextFont());
        this.backgroundLabel.add(license);
        license.setBounds(licenseBounds);
        JTextPane thirdParty = new JTextPane();
        StyleConstants.setAlignment(thirdParty.getLogicalStyle(), 1);
        thirdParty.setText((String)propertiesModel.getValue("about.thirdparty"));
        thirdParty.setOpaque(false);
        thirdParty.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        thirdParty.setEditable(false);
        thirdParty.setForeground(this.thirdPartyColor);
        thirdParty.setFont(MetalLookAndFeel.getSubTextFont());
        this.backgroundLabel.add(thirdParty);
        thirdParty.setBounds(20, 210, 365, 110);
        this.okButton = new JButton("Ok");
        this.okButton.setOpaque(false);
        this.okButton.setForeground(this.okForegroundColor);
        this.okButton.setBackground(this.okBackgroundColor);
        this.okButton.setBorder(new KunststoffButtonBorder(new Color(108, 136, 163), new Color(128, 156, 203), new Color(36, 76, 148)));
        this.backgroundLabel.add(this.okButton);
        this.okButton.setLocation(187 - this.okButton.getPreferredSize().width / 2, 320);
        this.okButton.setSize(this.okButton.getPreferredSize());
        JTextPane copyright = new JTextPane();
        copyright.setText((String)propertiesModel.getValue("about.copyright"));
        StyleConstants.setAlignment(copyright.getLogicalStyle(), 1);
        copyright.setOpaque(false);
        copyright.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        copyright.setEditable(false);
        copyright.setForeground(this.copyrightColor);
        copyright.setFont(MetalLookAndFeel.getSubTextFont());
        this.backgroundLabel.add(copyright);
        copyright.setBounds(0, 370, 400, 40);
        this.backgroundLabel.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.setLayout(new OverlayLayout(this));
        this.add(this.backgroundLabel);
        this.validate();
    }

    public int getVersionY() {
        return this.versionY;
    }

    public void setVersionY(int versionY) {
        this.versionY = versionY;
    }

    public void setActionListener(ActionListener listener) {
        this.okButton.addActionListener(this.actionListeners.create(listener, (Object)this.okButton));
    }
}

