/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.window;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.swing.window.ResourcesSplashPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashWindow
extends JWindow {
    public SplashWindow(ResourcesModel resourceModel, String filename, ApplicationModel applicationModel, JFrame f, int waitTime) {
        this(resourceModel, filename, applicationModel, f, waitTime, false);
    }

    public SplashWindow(ResourcesModel resourceModel, String filename, ApplicationModel applicationModel, JFrame f, int waitTime, boolean displayCopyright) {
        super(f);
        ResourcesSplashPanel splashPanel = new ResourcesSplashPanel(resourceModel, filename, applicationModel, displayCopyright);
        this.getContentPane().add((Component)((Object)splashPanel), "Center");
        this.pack();
        Dimension labelSize = splashPanel.getPreferredSize();
        if (f != null) {
            Point p = f.getLocationOnScreen();
            Dimension windowSize = f.getSize();
            int diffX = windowSize.width - labelSize.width;
            int diffY = windowSize.height - labelSize.height;
            this.setLocation(p.x + diffX / 2, p.y + diffY / 2);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        });
        this.startTimer(waitTime);
    }

    public void startTimer(int waitTime) {
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        };
        this.setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }
}

