/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc;

import java.io.IOException;
import java.io.OutputStream;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.EventTypeList;
import org.openexi.proc.common.GrammarOptions;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.SchemaId;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.grammars.OptionsGrammarCache;
import org.openexi.proc.io.BitOutputStream;
import org.openexi.proc.io.BitPackedScriber;
import org.openexi.proc.io.IntegerValueScriber;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ScriberFactory;
import org.openexi.schema.EXISchema;

public final class EXIOptionsEncoder {
    private final GrammarCache m_grammarCache = OptionsGrammarCache.getGrammarCache();
    private final BitPackedScriber m_scriber;
    private final Scribble m_scribble;
    private final EXISchema m_schema = this.m_grammarCache.getEXISchema();
    private final int m_unsignedIntType;
    private final IntegerValueScriber m_valueScriberUnsignedInt;

    public EXIOptionsEncoder() {
        StringTable stringTable = Scriber.createStringTable(this.m_grammarCache);
        this.m_scriber = ScriberFactory.createHeaderOptionsScriber();
        this.m_scriber.setSchema(this.m_grammarCache.getEXISchema(), null, 0);
        this.m_scriber.setPreserveNS(GrammarOptions.hasNS(this.m_grammarCache.grammarOptions));
        this.m_scriber.setStringTable(stringTable);
        this.m_scriber.setValueMaxLength(-1);
        this.m_scribble = new Scribble();
        this.m_unsignedIntType = this.m_schema.getBuiltinTypeOfSchema(33);
        this.m_valueScriberUnsignedInt = (IntegerValueScriber)this.m_scriber.getValueScriber(this.m_unsignedIntType);
    }

    public BitOutputStream encode(EXIOptions eXIOptions, boolean bl, boolean bl2, OutputStream outputStream) throws IOException, EXIOptionsException {
        int n;
        int n2;
        this.m_scriber.reset();
        this.m_scriber.setOutputStream(outputStream);
        this.m_grammarCache.retrieveRootGrammar(false, this.m_scriber.eventTypesWorkSpace).init(this.m_scriber.currentState);
        EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
        EventType eventType = eventTypeList.item(0);
        assert (eventType.itemType == 13 && eventTypeList.getLength() == 1);
        this.m_scriber.writeEventType(eventType);
        this.m_scriber.startDocument();
        eventTypeList = this.m_scriber.getNextEventTypes();
        eventType = eventTypeList.item(0);
        assert ("header".equals(eventType.name));
        this.m_scriber.writeEventType(eventType);
        this.m_scriber.startElement(eventType);
        eventTypeList = this.m_scriber.getNextEventTypes();
        int n3 = 0;
        if (!bl && bl2) {
            bl = true;
        }
        AlignmentType alignmentType = eXIOptions.getAlignmentType();
        int n4 = eXIOptions.getOutline(bl);
        if ((n4 & 1) != 0) {
            int n5;
            eventType = eventTypeList.item(n3++);
            assert ("lesscommon".equals(eventType.name));
            this.m_scriber.writeEventType(eventType);
            this.m_scriber.startElement(eventType);
            eventTypeList = this.m_scriber.getNextEventTypes();
            n2 = 0;
            if ((n4 & 2) != 0) {
                eventType = eventTypeList.item(n2++);
                assert ("uncommon".equals(eventType.name));
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.startElement(eventType);
                eventTypeList = this.m_scriber.getNextEventTypes();
                n5 = 0;
                if ((n4 & 4) != 0) {
                    String string;
                    eventType = eventTypeList.item(n5++);
                    assert ("alignment".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    if (alignmentType == AlignmentType.byteAligned) {
                        n = 0;
                        string = "byte";
                    } else {
                        assert (alignmentType == AlignmentType.preCompress);
                        n = 1;
                        string = "pre-compress";
                    }
                    eventType = eventTypeList.item(n);
                    assert (string.equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.item(0);
                    assert (eventType.itemType == 9);
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                if ((n4 & 0x20) != 0) {
                    n = 2 - n5;
                    eventType = eventTypeList.item(n);
                    n5 = 3;
                    assert ("valueMaxLength".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    int n6 = eventType.getNameId();
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.item(0);
                    assert (eventType.itemType == 19);
                    this.m_valueScriberUnsignedInt.processUnsignedInt(eXIOptions.getValueMaxLength(), this.m_scribble);
                    this.m_valueScriberUnsignedInt.scribe(null, this.m_scribble, n6, 4, this.m_unsignedIntType, this.m_scriber);
                    this.m_scriber.characters(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                if ((n4 & 0x40) != 0) {
                    n = 3 - n5;
                    eventType = eventTypeList.item(n);
                    n5 = 4;
                    assert ("valuePartitionCapacity".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    int n7 = eventType.getNameId();
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.item(0);
                    assert (eventType.itemType == 19);
                    this.m_valueScriberUnsignedInt.processUnsignedInt(eXIOptions.getValuePartitionCapacity(), this.m_scribble);
                    this.m_valueScriberUnsignedInt.scribe(null, this.m_scribble, n7, 4, this.m_unsignedIntType, this.m_scriber);
                    this.m_scriber.characters(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                if ((n4 & 0x100) != 0) {
                    n = 4 - n5;
                    n5 = 5;
                    QName[] qNameArray = eXIOptions.getDatatypeRepresentationMap();
                    int n8 = eXIOptions.getDatatypeRepresentationMapBindingsCount();
                    for (int i = 0; i < n8; ++i) {
                        eventType = eventTypeList.item(n);
                        assert ("datatypeRepresentationMap".equals(eventType.name));
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.startElement(eventType);
                        eventTypeList = this.m_scriber.getNextEventTypes();
                        QName qName = qNameArray[i << 1];
                        eventType = eventTypeList.item(0);
                        assert (eventTypeList.getLength() == 1 && eventType.itemType == 14);
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.writeQName(qName, eventType);
                        this.m_scriber.startWildcardElement(0, qName.uriId, qName.localNameId);
                        eventTypeList = this.m_scriber.getNextEventTypes();
                        eventType = eventTypeList.getEE();
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.endElement();
                        eventTypeList = this.m_scriber.getNextEventTypes();
                        qName = qNameArray[(i << 1) + 1];
                        eventType = eventTypeList.item(0);
                        assert (eventTypeList.getLength() == 1 && eventType.itemType == 14);
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.writeQName(qName, eventType);
                        this.m_scriber.startWildcardElement(0, qName.uriId, qName.localNameId);
                        eventTypeList = this.m_scriber.getNextEventTypes();
                        eventType = eventTypeList.getEE();
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.endElement();
                        eventTypeList = this.m_scriber.getNextEventTypes();
                        eventType = eventTypeList.getEE();
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.endElement();
                        eventTypeList = this.m_scriber.getNextEventTypes();
                        n = 0;
                    }
                }
                eventType = eventTypeList.getEE();
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.endElement();
                eventTypeList = this.m_scriber.getNextEventTypes();
            }
            if ((n4 & 8) != 0) {
                n = 1 - n2;
                eventType = eventTypeList.item(n);
                n2 = 2;
                assert ("preserve".equals(eventType.name));
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.startElement(eventType);
                eventTypeList = this.m_scriber.getNextEventTypes();
                n5 = 0;
                if (eXIOptions.getPreserveDTD()) {
                    eventType = eventTypeList.item(n5++);
                    assert ("dtd".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                if (eXIOptions.getPreserveNS()) {
                    n = 1 - n5;
                    eventType = eventTypeList.item(n);
                    n5 = 2;
                    assert ("prefixes".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                if (eXIOptions.getPreserveLexicalValues()) {
                    n = 2 - n5;
                    eventType = eventTypeList.item(n);
                    n5 = 3;
                    assert ("lexicalValues".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                if (eXIOptions.getPreserveComments()) {
                    n = 3 - n5;
                    eventType = eventTypeList.item(n);
                    n5 = 4;
                    assert ("comments".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                if (eXIOptions.getPreservePIs()) {
                    n = 4 - n5;
                    eventType = eventTypeList.item(n);
                    n5 = 5;
                    assert ("pis".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                }
                eventType = eventTypeList.getEE();
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.endElement();
                eventTypeList = this.m_scriber.getNextEventTypes();
            }
            if ((n5 = eXIOptions.getBlockSize()) != 1000000 && (alignmentType == AlignmentType.compress || alignmentType == AlignmentType.preCompress)) {
                n = 2 - n2;
                eventType = eventTypeList.item(n);
                n2 = 3;
                assert ("blockSize".equals(eventType.name));
                this.m_scriber.writeEventType(eventType);
                int n9 = eventType.getNameId();
                this.m_scriber.startElement(eventType);
                eventTypeList = this.m_scriber.getNextEventTypes();
                eventType = eventTypeList.item(0);
                assert (eventType.itemType == 19);
                this.m_valueScriberUnsignedInt.processUnsignedInt(n5, this.m_scribble);
                this.m_valueScriberUnsignedInt.scribe(null, this.m_scribble, n9, 4, this.m_unsignedIntType, this.m_scriber);
                this.m_scriber.characters(eventType);
                eventTypeList = this.m_scriber.getNextEventTypes();
                eventType = eventTypeList.getEE();
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.endElement();
                eventTypeList = this.m_scriber.getNextEventTypes();
            }
            eventType = eventTypeList.getEE();
            this.m_scriber.writeEventType(eventType);
            this.m_scriber.endElement();
            eventTypeList = this.m_scriber.getNextEventTypes();
        }
        if ((n4 & 0x10) != 0) {
            n = 1 - n3;
            eventType = eventTypeList.item(n);
            n3 = 2;
            assert ("common".equals(eventType.name));
            this.m_scriber.writeEventType(eventType);
            this.m_scriber.startElement(eventType);
            eventTypeList = this.m_scriber.getNextEventTypes();
            n2 = 0;
            if (alignmentType == AlignmentType.compress) {
                eventType = eventTypeList.item(n2++);
                assert ("compression".equals(eventType.name));
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.startElement(eventType);
                eventTypeList = this.m_scriber.getNextEventTypes();
                eventType = eventTypeList.getEE();
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.endElement();
                eventTypeList = this.m_scriber.getNextEventTypes();
            }
            if (eXIOptions.isFragment()) {
                n = 1 - n2;
                eventType = eventTypeList.item(n);
                n2 = 2;
                assert ("fragment".equals(eventType.name));
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.startElement(eventType);
                eventTypeList = this.m_scriber.getNextEventTypes();
                eventType = eventTypeList.getEE();
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.endElement();
                eventTypeList = this.m_scriber.getNextEventTypes();
            }
            if (bl) {
                SchemaId schemaId = eXIOptions.getSchemaId();
                if (schemaId != null) {
                    n = 2 - n2;
                    eventType = eventTypeList.item(n);
                    assert ("schemaId".equals(eventType.name));
                    this.m_scriber.writeEventType(eventType);
                    int n10 = eventType.getNameId();
                    this.m_scriber.startElement(eventType);
                    eventTypeList = this.m_scriber.getNextEventTypes();
                    String string = schemaId.getValue();
                    if (string == null) {
                        eventType = eventTypeList.item(0);
                        assert (eventType.itemType == 21);
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.writeBoolean(true);
                        this.m_scriber.nillify(eventType.getIndex());
                        eventTypeList = this.m_scriber.getNextEventTypes();
                    } else {
                        eventType = eventTypeList.item(1);
                        assert (eventType.itemType == 19);
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.getValueScriberByID((short)15).scribe(string, this.m_scribble, n10, 4, this.m_scriber.currentState.contentDatatype, this.m_scriber);
                        this.m_scriber.characters(eventType);
                        eventTypeList = this.m_scriber.getNextEventTypes();
                    }
                    eventType = eventTypeList.getEE();
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.endElement();
                    eventTypeList = this.m_scriber.getNextEventTypes();
                } else {
                    throw new EXIOptionsException("schemaId needs to be specified.");
                }
            }
            eventType = eventTypeList.getEE();
            this.m_scriber.writeEventType(eventType);
            this.m_scriber.endElement();
            eventTypeList = this.m_scriber.getNextEventTypes();
        }
        if (eXIOptions.isStrict()) {
            n = 2 - n3;
            eventType = eventTypeList.item(n);
            n3 = 3;
            assert ("strict".equals(eventType.name));
            this.m_scriber.writeEventType(eventType);
            this.m_scriber.startElement(eventType);
            eventTypeList = this.m_scriber.getNextEventTypes();
            eventType = eventTypeList.getEE();
            this.m_scriber.writeEventType(eventType);
            this.m_scriber.endElement();
            eventTypeList = this.m_scriber.getNextEventTypes();
        }
        eventType = eventTypeList.getEE();
        this.m_scriber.writeEventType(eventType);
        this.m_scriber.endElement();
        eventTypeList = this.m_scriber.getNextEventTypes();
        eventType = eventTypeList.item(0);
        assert (eventType.itemType == 4);
        this.m_scriber.writeEventType(eventType);
        this.m_scriber.endDocument();
        if (eXIOptions.getAlignmentType() != AlignmentType.bitPacked) {
            this.m_scriber.finish();
        }
        return this.m_scriber.getBitOutputStream();
    }
}

