/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.resources;

import com.macrofocus.resources.AbstractResourcesModel;
import com.macrofocus.resources.LocaleHelper;
import com.macrofocus.resources.PreferencesHelper;
import com.macrofocus.resources.ResourcesEvent;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.resources.properties.ResourceBundlePropertiesModel;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ResourceBundleResourcesModel
extends AbstractResourcesModel {
    private final Class mainClass;
    private Class resourceClass;
    private final List<Class> classes;
    private PropertiesModel propertiesModel;
    private Locale locale;
    private Set<String> preferencesKeys;

    public ResourceBundleResourcesModel(Class mainClass, Class resourceBundle, Locale locale, String[] preferences) {
        this.mainClass = mainClass;
        this.resourceClass = resourceBundle;
        this.classes = new ArrayList<Class>();
        this.classes.add(resourceBundle);
        this.preferencesKeys = new HashSet<String>();
        if (preferences != null) {
            for (int i = 0; i < preferences.length; ++i) {
                String preference = preferences[i];
                this.preferencesKeys.add(preference);
            }
        }
        this.setLocale(locale);
        this.retrievePreferences();
    }

    public ResourceBundleResourcesModel(Class mainClass, Class resourceBundle, Locale locale) {
        this.mainClass = mainClass;
        this.resourceClass = resourceBundle;
        this.classes = new ArrayList<Class>();
        this.classes.add(resourceBundle);
        this.preferencesKeys = null;
        this.setLocale(locale);
        this.retrievePreferences();
    }

    public void setResourceClass(Class resourceClass) {
        this.resourceClass = resourceClass;
    }

    @Override
    public URL getUrl(String filename) {
        return this.resourceClass.getResource(filename);
    }

    @Override
    public URL getUrl(Class context, String filename) {
        return context.getResource(filename);
    }

    @Override
    public URL getLocalizedUrl(String name, String extension) {
        Enumeration enumeration = LocaleHelper.getCandidates(this.locale);
        while (enumeration.hasMoreElements()) {
            String s2 = (String)enumeration.nextElement();
            String filename = name + s2 + extension;
            URL url = this.getUrl(filename);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public PropertiesModel getPropertiesModel() {
        if (this.propertiesModel == null) {
            this.reload();
        }
        return this.propertiesModel;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            try {
                Locale.setDefault(locale);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            this.reload();
        }
    }

    @Override
    public void reload() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new ResourceBundlePropertiesModel();
        }
        ResourceBundlePropertiesModel propertiesModel = new ResourceBundlePropertiesModel();
        for (int i = 0; i < this.classes.size(); ++i) {
            Class cl = this.classes.get(i);
            this.loadProperties(propertiesModel, cl);
        }
        this.propertiesModel.resetValues(propertiesModel);
        this.retrievePreferences();
        this.notifyResourcesLocaleChanged(new ResourcesEvent(this, this));
    }

    @Override
    public void retrievePreferences() {
        if (this.preferencesKeys != null) {
            try {
                Object newValue;
                Object currentValue;
                String key;
                int i;
                Preferences userPreferencesRoot = Preferences.userNodeForPackage(this.mainClass);
                String[] keys = userPreferencesRoot.keys();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!this.preferencesKeys.contains(key)) continue;
                    currentValue = this.propertiesModel.getValue(key);
                    try {
                        if (currentValue instanceof String) {
                            newValue = userPreferencesRoot.get(key, (String)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.put(key, (String)newValue);
                            continue;
                        }
                        if (currentValue instanceof Boolean) {
                            newValue = new Boolean(userPreferencesRoot.getBoolean(key, (Boolean)currentValue));
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putBoolean(key, (Boolean)newValue);
                            continue;
                        }
                        if (currentValue instanceof Double) {
                            newValue = userPreferencesRoot.getDouble(key, (Double)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putDouble(key, (Double)newValue);
                            continue;
                        }
                        if (currentValue instanceof Float) {
                            newValue = Float.valueOf(userPreferencesRoot.getFloat(key, ((Float)currentValue).floatValue()));
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putFloat(key, ((Float)newValue).floatValue());
                            continue;
                        }
                        if (currentValue instanceof Integer) {
                            newValue = userPreferencesRoot.getInt(key, (Integer)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putInt(key, (Integer)newValue);
                            continue;
                        }
                        if (currentValue instanceof Long) {
                            newValue = userPreferencesRoot.getLong(key, (Long)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putLong(key, (Long)newValue);
                            continue;
                        }
                        if (currentValue instanceof String[]) continue;
                        try {
                            Object value = PreferencesHelper.getObject(userPreferencesRoot, key);
                            if (value == null) continue;
                            this.propertiesModel.setValue(key, value);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                }
                keys = userPreferencesRoot.childrenNames();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!this.preferencesKeys.contains(key) || !((currentValue = this.propertiesModel.getValue(key)) instanceof String[])) continue;
                    newValue = PreferencesHelper.loadArray(userPreferencesRoot.node(key));
                    this.propertiesModel.setValue(key, newValue);
                }
            }
            catch (AccessControlException userPreferencesRoot) {
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void savePreferences() {
        if (this.preferencesKeys != null) {
            try {
                Preferences userPreferencesRoot = Preferences.userNodeForPackage(this.mainClass);
                for (String key : this.preferencesKeys) {
                    if (!this.propertiesModel.isAvailable(key)) continue;
                    Object value = this.propertiesModel.getValue(key);
                    if (value instanceof String) {
                        userPreferencesRoot.put(key, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        userPreferencesRoot.putBoolean(key, (Boolean)value);
                        continue;
                    }
                    if (value instanceof Double) {
                        userPreferencesRoot.putDouble(key, (Double)value);
                        continue;
                    }
                    if (value instanceof Float) {
                        userPreferencesRoot.putFloat(key, ((Float)value).floatValue());
                        continue;
                    }
                    if (value instanceof Integer) {
                        userPreferencesRoot.putInt(key, (Integer)value);
                        continue;
                    }
                    if (value instanceof Long) {
                        userPreferencesRoot.putLong(key, (Long)value);
                        continue;
                    }
                    if (value instanceof String[]) {
                        try {
                            PreferencesHelper.saveArray(userPreferencesRoot.node(key), (String[])value);
                        }
                        catch (BackingStoreException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        PreferencesHelper.putObject(userPreferencesRoot, key, value);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    userPreferencesRoot.sync();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    @Override
    public void resetPreferences() {
        if (this.preferencesKeys != null) {
            Preferences userPreferencesRoot = Preferences.userNodeForPackage(this.mainClass);
            try {
                userPreferencesRoot.clear();
                userPreferencesRoot.sync();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadProperties(PropertiesModel propertiesModel, Class cl) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(cl.getName(), this.locale, cl.getClassLoader());
        if (propertiesModel != null) {
            propertiesModel.setValues(new ResourceBundlePropertiesModel(resourceBundle));
        } else {
            propertiesModel = new ResourceBundlePropertiesModel(resourceBundle);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void addClass(Class cl) {
        this.classes.add(cl);
        this.loadProperties(this.propertiesModel, cl);
        this.notifyResourcesLocaleChanged(new ResourcesEvent(this, this));
    }

    public String toString() {
        return "ResourceBundleResourcesModel{mainClass=" + String.valueOf(this.mainClass) + ", resourceClass=" + String.valueOf(this.resourceClass) + ", locale=" + String.valueOf(this.locale) + "}";
    }
}

